/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.util;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModSpecificDeferredRegister<T> {
    private final DeferredRegister<T> register;
    private final String modid;

    public ModSpecificDeferredRegister(DeferredRegister<T> register, String modid) {
        this.register = register;
        this.modid = modid;
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        return this.register.register(name, sup);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup, String requiredModid) {
        RegistryObject obj = this.register.register(name, sup);
        if (!ModList.get().isLoaded(requiredModid)) {
            this.register.getEntries().remove(obj);
        }
        return obj;
    }

    public <E extends IForgeRegistryEntry<E>> Supplier<IForgeRegistry<E>> makeRegistry(Class<E> base, Supplier<RegistryBuilder<E>> sup) {
        return this.register.makeRegistry(base, sup);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull String path) {
        return this.register.createTagKey(path);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull ResourceLocation location) {
        return this.register.createTagKey(location);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull String path, @NotNull Set<? extends Supplier<T>> defaults) {
        return this.register.createOptionalTagKey(path, defaults);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull ResourceLocation location, @NotNull Set<? extends Supplier<T>> defaults) {
        return this.register.createOptionalTagKey(location, defaults);
    }

    public void addOptionalTagDefaults(@NotNull TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        this.register.addOptionalTagDefaults(name, defaults);
    }

    public void register(IEventBus bus) {
        this.register.register(bus);
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.register.getEntries();
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.register.getRegistryName();
    }
}

