/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.handlers;

import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class ClientRenderHandler {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> prop = entry.getKey();
            return prop.m_61708_() + "=" + this.getPropertyName(prop, entry.getValue());
        }

        private <T extends Comparable<T>> String getPropertyName(Property<T> property, Comparable<?> entry) {
            return property.m_6940_(entry);
        }
    };

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlockHighlight(RenderHighlightEvent.Block event) {
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(event.getTarget().m_82425_());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (!player.m_7500_() || player.m_7500_() && player.m_6047_())) {
            double z;
            double y;
            double x;
            if (state.m_60734_() == DSBlocks.DOUBLE_SLAB.get()) {
                x = (double)event.getTarget().m_82425_().m_123341_() - event.getCamera().m_90583_().f_82479_;
                y = (double)event.getTarget().m_82425_().m_123342_() - event.getCamera().m_90583_().f_82480_;
                z = (double)event.getTarget().m_82425_().m_123343_() - event.getCamera().m_90583_().f_82481_;
                if (event.getTarget().m_82450_().f_82480_ - (double)event.getTarget().m_82425_().m_123342_() > 0.5) {
                    LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)x, (double)(y + 0.5), (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                } else {
                    LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 0.5), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                }
                event.setCanceled(true);
            }
            if (state.m_60734_() == DSBlocks.VERTICAL_SLAB.get() && ((Boolean)state.m_61143_((Property)VerticalSlabBlock.DOUBLE)).booleanValue()) {
                x = (double)event.getTarget().m_82425_().m_123341_() - event.getCamera().m_90583_().f_82479_;
                y = (double)event.getTarget().m_82425_().m_123342_() - event.getCamera().m_90583_().f_82480_;
                z = (double)event.getTarget().m_82425_().m_123343_() - event.getCamera().m_90583_().f_82481_;
                switch (((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122434_()) {
                    case X: {
                        if (event.getTarget().m_82450_().f_82479_ - (double)event.getTarget().m_82425_().m_123341_() > 0.5) {
                            LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)(x + 0.5), (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)x, (double)y, (double)z, (double)(x + 0.5), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                    case Z: {
                        if (event.getTarget().m_82450_().f_82481_ - (double)event.getTarget().m_82425_().m_123343_() > 0.5) {
                            LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)x, (double)y, (double)(z + 0.5), (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            LevelRenderer.m_109608_((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 0.5), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                }
            }
        }
    }

    private static String stateToString(@Nullable BlockState state) {
        if (state == null) {
            return ChatFormatting.RED + "null";
        }
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())) + "[" + state.m_61148_().entrySet().stream().map(MAP_ENTRY_TO_STRING).collect(Collectors.joining(",")) + "]";
    }

    private static String tileToString(@Nullable BlockEntity tile) {
        if (tile == null) {
            return ChatFormatting.RED + "null";
        }
        String data = tile.getPersistentData().toString();
        return Objects.requireNonNull(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_())) + data;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlayText(CustomizeGuiOverlayEvent.DebugText event) {
        BlockPos pos;
        BlockEntity tileEntity;
        if (Minecraft.m_91087_().f_91066_.f_92063_ && Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK && (tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos = ((BlockHitResult)Minecraft.m_91087_().f_91077_).m_82425_())) instanceof SlabTileEntity) {
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            event.getRight().add("");
            event.getRight().add("Slab Types");
            event.getRight().add("Positive Block: " + ClientRenderHandler.stateToString(tile.getPositiveBlockInfo().getBlockState()));
            event.getRight().add("Positive Tile: " + ClientRenderHandler.tileToString(tile.getPositiveBlockInfo().getBlockEntity()));
            event.getRight().add("Negative Block: " + ClientRenderHandler.stateToString(tile.getNegativeBlockInfo().getBlockState()));
            event.getRight().add("Negative Tile: " + ClientRenderHandler.tileToString(tile.getNegativeBlockInfo().getBlockEntity()));
        }
    }
}

