/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.render;

import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SlabTileEntityRenderer
implements BlockEntityRenderer<SlabTileEntity> {
    private static final Quaternion NORTH_ROTATION = Vector3f.f_122223_.m_122240_(90.0f);
    private static final Quaternion SOUTH_ROTATION = Vector3f.f_122222_.m_122240_(90.0f);
    private static final Quaternion WEST_ROTATION = Vector3f.f_122226_.m_122240_(90.0f);
    private static final Quaternion EAST_ROTATION = Vector3f.f_122227_.m_122240_(90.0f);

    public SlabTileEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SlabTileEntity slab, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = slab.m_58899_();
        Level world = slab.m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (slab.getPositiveBlockInfo().getBlockEntity() == null && slab.getNegativeBlockInfo().getBlockEntity() == null) {
            return;
        }
        if (slab.getPositiveBlockInfo().getBlockEntity() != null) {
            slab.getPositiveBlockInfo().getBlockEntity().m_142339_(slab.getPositiveBlockInfo().getWorld());
        }
        if (slab.getNegativeBlockInfo().getBlockEntity() != null) {
            slab.getNegativeBlockInfo().getBlockEntity().m_142339_(slab.getNegativeBlockInfo().getWorld());
        }
        if (state.m_60734_() == DSBlocks.DOUBLE_SLAB.get()) {
            if (slab.getPositiveBlockInfo().getBlockEntity() != null) {
                Minecraft.m_91087_().m_167982_().m_112267_(slab.getPositiveBlockInfo().getBlockEntity(), partialTicks, poseStack, buffer);
            }
            if (slab.getNegativeBlockInfo().getBlockEntity() != null) {
                Minecraft.m_91087_().m_167982_().m_112267_(slab.getNegativeBlockInfo().getBlockEntity(), partialTicks, poseStack, buffer);
            }
        } else if (state.m_60734_() == DSBlocks.VERTICAL_SLAB.get()) {
            Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)VerticalSlabBlock.FACING);
            poseStack.m_85836_();
            switch (facing) {
                case NORTH: {
                    poseStack.m_85845_(NORTH_ROTATION);
                    poseStack.m_85837_(0.0, 0.0, -1.0);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85845_(SOUTH_ROTATION);
                    poseStack.m_85837_(0.0, -1.0, 0.0);
                    break;
                }
                case WEST: {
                    poseStack.m_85845_(WEST_ROTATION);
                    poseStack.m_85837_(-1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    poseStack.m_85845_(EAST_ROTATION);
                    poseStack.m_85837_(0.0, -1.0, 0.0);
                }
            }
            if (slab.getNegativeBlockInfo().getBlockEntity() != null) {
                Minecraft.m_91087_().m_167982_().m_112267_(slab.getNegativeBlockInfo().getBlockEntity(), partialTicks, poseStack, buffer);
            }
            if (slab.getPositiveBlockInfo().getBlockEntity() != null) {
                Minecraft.m_91087_().m_167982_().m_112267_(slab.getPositiveBlockInfo().getBlockEntity(), partialTicks, poseStack, buffer);
            }
            poseStack.m_85849_();
        }
    }
}

