/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wolfshotz.dml.DMLSounds;
import wolfshotz.dml.block.DragonEggBlock;
import wolfshotz.dml.client.ClientEvents;
import wolfshotz.dml.cmd.DragonSetAgeCommand;
import wolfshotz.dml.entity.DMLEntities;
import wolfshotz.dml.item.DragonEggBlockItem;
import wolfshotz.dml.network.EggHatchPacket;

@Mod(value="dragonmounts")
public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger L = LogManager.getLogger((String)"dragonmounts");
    public static final String PROTOCOL_VER = "1.0";
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.rl("network")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
    public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "dragonmounts");

    public DragonMountsLegacy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(ClientEvents::clientSetup);
            bus.addListener(ClientEvents::itemColors);
        });
        DragonEggBlock.register(bus);
        DMLEntities.ENTITIES.register(bus);
        DMLSounds.SOUNDS.register(bus);
        ITEMS.register(bus);
        MinecraftForge.EVENT_BUS.addListener(this::startingServer);
        MinecraftForge.EVENT_BUS.addListener(this::loadLootTables);
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        int index = 0;
        NETWORK.registerMessage(++index, EggHatchPacket.class, EggHatchPacket::encode, EggHatchPacket::new, EggHatchPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void startingServer(FMLServerStartingEvent evt) {
        evt.getCommandDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"dragon").then(DragonSetAgeCommand.register()));
    }

    public void loadLootTables(LootTableLoadEvent evt) {
        float chance;
        ResourceLocation table = evt.getName();
        if (table.equals((Object)LootTables.field_186422_d)) {
            chance = 0.9f;
        } else if (table.equals((Object)LootTables.field_186424_f)) {
            chance = 0.45f;
        } else if (table.equals((Object)LootTables.field_186429_k)) {
            chance = 0.3f;
        } else if (table.equals((Object)LootTables.field_186421_c)) {
            chance = 0.8f;
        } else {
            return;
        }
        LootPool.Builder pool = LootPool.func_216096_a().name("dragonmounts_added_eggs").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance));
        ITEMS.getEntries().stream().filter(e -> e.get() instanceof DragonEggBlockItem).forEach(e -> pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)e.get()))));
        evt.getTable().addPool(pool.func_216044_b());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

