/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.entity.dragonegg.DragonEggEntity;
import wolfshotz.dml.entity.dragonegg.EnumEggTypes;
import wolfshotz.dml.item.DragonEggBlockItem;

@Mod.EventBusSubscriber(modid="dragonmounts")
public class DragonEggBlock
extends net.minecraft.block.DragonEggBlock {
    @ObjectHolder(value="dragonmounts:dragon_egg")
    public static final Block INSTANCE = null;
    public static final EnumProperty<EnumEggTypes> BREED = EnumProperty.func_177709_a((String)"breed", EnumEggTypes.class);

    public DragonEggBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(BREED, (Comparable)((Object)EnumEggTypes.AETHER)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BREED});
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (state.func_177229_b(BREED) == EnumEggTypes.ENDER) {
            super.func_196270_a(state, worldIn, pos, player);
        }
    }

    public static void register(IEventBus bus) {
        bus.addGenericListener(Block.class, e -> e.getRegistry().register(new DragonEggBlock(Block.Properties.func_200950_a((Block)Blocks.field_150380_bt)).setRegistryName("dragon_egg")));
    }

    public static ItemStack toItem(BlockState state) {
        return new ItemStack((IItemProvider)DragonMountsLegacy.ITEMS.getEntries().stream().map(RegistryObject::get).filter(DragonEggBlockItem.class::isInstance).map(DragonEggBlockItem.class::cast).filter(i -> i.getType() == state.func_177229_b(BREED)).findFirst().get());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        DragonEggBlock.startHatching(state, worldIn, pos);
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        EnumEggTypes type = ((DragonEggBlockItem)context.func_195996_i().func_77973_b()).getType();
        return (BlockState)this.func_176223_P().func_206870_a(BREED, (Comparable)((Object)type));
    }

    public static void startHatching(BlockState state, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            DragonEggEntity egg = new DragonEggEntity((EnumEggTypes)((Object)state.func_177229_b(BREED)), world);
            egg.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)egg);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return DragonEggBlock.toItem(state);
    }

    @SubscribeEvent
    public static void onVanillaEggActivate(PlayerInteractEvent.RightClickBlock evt) {
        World world = evt.getWorld();
        Block block = world.func_180495_p(evt.getPos()).func_177230_c();
        if (block == Blocks.field_150380_bt) {
            evt.setCanceled(true);
            evt.setUseBlock(Event.Result.DENY);
            DragonEggBlock.startHatching((BlockState)INSTANCE.func_176223_P().func_206870_a(BREED, (Comparable)((Object)EnumEggTypes.ENDER)), world, evt.getPos());
        }
    }
}

