/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client;

import net.minecraft.entity.EntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.client.render.DragonRenderer;
import wolfshotz.dml.client.render.EggRenderer;
import wolfshotz.dml.entity.DMLEntities;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;
import wolfshotz.dml.item.DragonSpawnEggItem;

@Mod.EventBusSubscriber(modid="dragonmounts", value={Dist.CLIENT})
public class ClientEvents {
    public static void clientSetup(FMLClientSetupEvent evt) {
        ClientEvents.registerRenders();
    }

    public static void registerRenders() {
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.AETHER_DAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.ENDER_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.FIRE_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.GHOST_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.FOREST_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.ICE_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.NETHER_DRAGON.get()));
        ClientEvents.registerRenderer((EntityType<TameableDragonEntity>)((EntityType)DMLEntities.WATER_DRAGON.get()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)DMLEntities.EGG.get()), EggRenderer::new);
    }

    public static void registerRenderer(EntityType<TameableDragonEntity> type) {
        RenderingRegistry.registerEntityRenderingHandler(type, rm -> new DragonRenderer(rm, type));
    }

    public static void itemColors(ColorHandlerEvent.Item evt) {
        DragonMountsLegacy.ITEMS.getEntries().stream().map(RegistryObject::get).filter(DragonSpawnEggItem.class::isInstance).map(DragonSpawnEggItem.class::cast).forEach(i -> evt.getItemColors().func_199877_a((s, c) -> i.getColor(c), new IItemProvider[]{i}));
    }
}

