/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.client.model.DragonModel;
import wolfshotz.dml.client.render.RenderStates;
import wolfshotz.dml.client.render.layer.DragonGlowLayer;
import wolfshotz.dml.client.render.layer.DragonSaddleLayer;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;

public class DragonRenderer
extends MobRenderer<TameableDragonEntity, DragonModel> {
    public static final String TEX_PATH = "textures/entity/dragon/";
    public static final ResourceLocation DISSOLVE_TEXTURE = DragonRenderer.rl("dissolve.png");
    public ResourceLocation bodyTexture;
    public ResourceLocation saddleTexture;
    public ResourceLocation glowTexture;

    public DragonRenderer(EntityRendererManager renderManagerIn, EntityType<TameableDragonEntity> type) {
        super(renderManagerIn, (EntityModel)new DragonModel(type), 2.0f);
        this.func_177094_a(new DragonGlowLayer(this));
        this.func_177094_a(new DragonSaddleLayer(this));
    }

    public void render(TameableDragonEntity dragon, float entityYaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)dragon, (LivingRenderer)this, partialTicks, ms, bufferIn, packedLightIn))) {
            return;
        }
        ms.func_227860_a_();
        ((DragonModel)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)dragon, partialTicks);
        ((DragonModel)this.field_77045_g).field_217114_e = dragon.func_70631_g_();
        float terpYawOff = MathHelper.func_219805_h((float)partialTicks, (float)dragon.field_70760_ar, (float)dragon.field_70761_aq);
        float terpYaw = MathHelper.func_219805_h((float)partialTicks, (float)dragon.field_70758_at, (float)dragon.field_70759_as);
        float yawDiff = terpYaw - terpYawOff;
        float lerpPitch = MathHelper.func_219799_g((float)partialTicks, (float)dragon.field_70127_C, (float)dragon.field_70125_A);
        float rotation = this.func_77044_a((LivingEntity)dragon, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (dragon.func_70089_S()) {
            limbSwingAmount = Math.min(1.0f, MathHelper.func_219799_g((float)partialTicks, (float)dragon.field_184618_aE, (float)dragon.field_70721_aZ));
            limbSwing = dragon.field_184619_aG - dragon.field_70721_aZ * (1.0f - partialTicks);
            if (dragon.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
        }
        this.applyRotations(dragon, ms, rotation, terpYawOff, partialTicks);
        ms.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(dragon, ms, partialTicks);
        ms.func_227861_a_(0.0, (double)-1.501f, 0.0);
        ((DragonModel)this.field_77045_g).setLivingAnimations(dragon, limbSwing, limbSwingAmount, partialTicks);
        ((DragonModel)this.field_77045_g).setRotationAngles(dragon, limbSwing, limbSwingAmount, rotation, yawDiff, lerpPitch);
        this.renderModel(dragon, ms, bufferIn, packedLightIn, partialTicks);
        if (!dragon.func_175149_v()) {
            for (LayerRenderer layer : this.field_177097_h) {
                layer.func_225628_a_(ms, bufferIn, packedLightIn, (Entity)dragon, limbSwing, limbSwingAmount, partialTicks, rotation, yawDiff, lerpPitch);
            }
        }
        ms.func_227865_b_();
        if (this.func_177070_b((MobEntity)dragon)) {
            this.func_225629_a_((Entity)dragon, dragon.func_145748_c_().func_150254_d(), ms, bufferIn, packedLightIn);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)dragon, (LivingRenderer)this, partialTicks, ms, bufferIn, packedLightIn));
    }

    public void renderModel(TameableDragonEntity dragon, MatrixStack ms, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        ResourceLocation texture = this.getEntityTexture(dragon);
        int packedOverlay = DragonRenderer.func_229117_c_((LivingEntity)dragon, (float)this.func_225625_b_((LivingEntity)dragon, partialTicks));
        float deathTime = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
        if (deathTime > 0.0f) {
            IVertexBuilder dissolve = buffer.getBuffer(RenderStates.func_228635_a_((ResourceLocation)DISSOLVE_TEXTURE, (float)deathTime));
            ((DragonModel)this.field_77045_g).func_225598_a_(ms, dissolve, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder decal = buffer.getBuffer(RenderStates.func_228648_g_((ResourceLocation)texture));
            ((DragonModel)this.field_77045_g).func_225598_a_(ms, decal, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)true), 1.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        boolean visibleToPlayer = !this.func_225622_a_((LivingEntity)dragon) && !dragon.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.func_230042_a_((LivingEntity)dragon, this.func_225622_a_((LivingEntity)dragon), visibleToPlayer));
        ((DragonModel)this.field_77045_g).func_225598_a_(ms, ivertexbuilder, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, visibleToPlayer ? 0.15f : 1.0f);
    }

    protected void preRenderCallback(TameableDragonEntity dragon, MatrixStack ms, float partialTickTime) {
        float scale = dragon.getScale() * 0.8f;
        ms.func_227862_a_(scale, scale, scale);
    }

    protected void applyRotations(TameableDragonEntity dragon, MatrixStack ms, float ageInTicks, float rotationYaw, float partialTicks) {
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
    }

    public ResourceLocation getEntityTexture(TameableDragonEntity entity) {
        if (this.bodyTexture == null) {
            this.bodyTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/body.png");
        }
        return this.bodyTexture;
    }

    public ResourceLocation getSaddleTexture(TameableDragonEntity entity) {
        if (this.saddleTexture == null) {
            this.saddleTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/saddle.png");
        }
        return this.saddleTexture;
    }

    public ResourceLocation getGlowTexture(TameableDragonEntity entity) {
        if (this.glowTexture == null) {
            this.glowTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/glow.png");
        }
        return this.glowTexture;
    }

    public static ResourceLocation rl(String path) {
        return DragonMountsLegacy.rl(TEX_PATH + path);
    }
}

