/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entity;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import wolfshotz.dml.entity.dragonegg.DragonEggEntity;
import wolfshotz.dml.entity.dragons.AetherDragonEntity;
import wolfshotz.dml.entity.dragons.EndDragonEntity;
import wolfshotz.dml.entity.dragons.FireDragonEntity;
import wolfshotz.dml.entity.dragons.ForestDragonEntity;
import wolfshotz.dml.entity.dragons.GhostDragonEntity;
import wolfshotz.dml.entity.dragons.IceDragonEntity;
import wolfshotz.dml.entity.dragons.NetherDragonEntity;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;
import wolfshotz.dml.entity.dragons.WaterDragonEntity;

public class DMLEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "dragonmounts");
    public static final RegistryObject<EntityType<TameableDragonEntity>> AETHER_DAGON = DMLEntities.dragon("aether_dragon", AetherDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> ENDER_DRAGON = DMLEntities.dragon("ender_dragon", EndDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> FIRE_DRAGON = DMLEntities.dragon("fire_dragon", FireDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> FOREST_DRAGON = DMLEntities.dragon("forest_dragon", ForestDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> GHOST_DRAGON = DMLEntities.dragon("ghost_dragon", GhostDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> ICE_DRAGON = DMLEntities.dragon("ice_dragon", IceDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> NETHER_DRAGON = DMLEntities.dragon("nether_dragon", NetherDragonEntity::new);
    public static final RegistryObject<EntityType<TameableDragonEntity>> WATER_DRAGON = DMLEntities.dragon("water_dragon", WaterDragonEntity::new);
    public static final RegistryObject<EntityType<DragonEggEntity>> EGG = ENTITIES.register("egg", () -> EntityType.Builder.func_220322_a(DragonEggEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 0.9f).setShouldReceiveVelocityUpdates(true).setUpdateInterval(20).setTrackingRange(10).func_200705_b().func_220320_c().func_206830_a("dragonmounts:egg"));

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType<T>> type) {
        return ENTITIES.register(name, type);
    }

    public static <T extends TameableDragonEntity> RegistryObject<EntityType<T>> dragon(String name, EntityType.IFactory<T> factory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(2.75f, 2.75f);
        if (name.contains("fire") || name.contains("nether")) {
            builder.func_220320_c();
        }
        return DMLEntities.register(name, () -> builder.func_206830_a("dragonmounts:" + name));
    }
}

