/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entity.dragonegg;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.block.DragonEggBlock;
import wolfshotz.dml.entity.DMLEntities;
import wolfshotz.dml.entity.dragonegg.EnumEggTypes;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;
import wolfshotz.dml.entity.dragons.ai.LifeStageController;
import wolfshotz.dml.network.EggHatchPacket;

public class DragonEggEntity
extends Entity {
    public static final float WIDTH = 0.9f;
    public static final float HEIGHT = 0.9f;
    public static final int CHECK_HABITAT_INTERVAL = 100;
    public static final int DEFAULT_HATCH_TIME = 12000;
    public static final float EGG_WIGGLE_THRESHOLD = 3000.0f;
    public static final String NBT_HATCH_TIME = "HatchTime";
    public static final String NBT_TYPE = "Type";
    private static final float EGG_CRACK_THRESHOLD = 2700.0f;
    private static final float EGG_WIGGLE_BASE_CHANCE = 20.0f;
    public static final DataParameter<String> EGG_TYPE = EntityDataManager.func_187226_a(DragonEggEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public int hatchTime;
    public EnumEggTypes eggType;

    public DragonEggEntity(EntityType<? extends DragonEggEntity> type, World world) {
        super(type, world);
    }

    public DragonEggEntity(EnumEggTypes type, World world) {
        super((EntityType)DMLEntities.EGG.get(), world);
        this.setEggType(type);
        this.hatchTime = 12000;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EGG_TYPE, (Object)"");
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.hatchTime = compound.func_74762_e(NBT_HATCH_TIME);
        this.setEggType(EnumEggTypes.valueOf(compound.func_74779_i(NBT_TYPE)));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_HATCH_TIME, this.hatchTime);
        compound.func_74778_a(NBT_TYPE, this.eggType.name());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(EGG_TYPE)) {
            this.eggType = EnumEggTypes.valueOf((String)this.field_70180_af.func_187225_a(EGG_TYPE));
        }
    }

    public void setEggType(EnumEggTypes type) {
        this.field_70180_af.func_187227_b(EGG_TYPE, (Object)type.name());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public void func_70071_h_() {
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.98, 0.3));
        this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), e -> !(e instanceof PlayerEntity)).forEach(arg_0 -> ((DragonEggEntity)this).func_70108_f(arg_0));
        if (!this.field_70170_p.field_72995_K) {
            if (this.eggType == null) {
                DragonMountsLegacy.L.error("null entity type for egg, removing...");
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 100 == 0) {
                this.updateHabitat();
            }
            if (--this.hatchTime <= 0) {
                EggHatchPacket.send(this);
                this.hatch();
                return;
            }
        } else {
            double px = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5);
            double py = this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5);
            double pz = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5);
            if (this.eggType == EnumEggTypes.ENDER) {
                double ox = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oy = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, px, py, pz, ox, oy, oz);
            } else {
                boolean primary = this.field_70146_Z.nextInt(3) != 0;
                float r = this.eggType.getRColor(primary);
                float g = this.eggType.getGColor(primary);
                float b = this.eggType.getBColor(primary);
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(r, g, b, 1.0f), px, py + 1.0, pz, 0.0, 0.0, 0.0);
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        super.func_70097_a(source, amount);
        this.func_199701_a_(DragonEggBlock.toItem((BlockState)DragonEggBlock.INSTANCE.func_176223_P().func_206870_a(DragonEggBlock.BREED, (Comparable)((Object)this.eggType))));
        this.func_70106_y();
        return false;
    }

    public void updateHabitat() {
        EnumEggTypes type = EnumEggTypes.getByHabitat(this);
        if (type == null) {
            return;
        }
        this.setEggType(type);
    }

    public void hatch() {
        if (this.field_70170_p.field_72995_K) {
            this.crack();
        } else {
            TameableDragonEntity dragon = (TameableDragonEntity)this.eggType.getType().func_200721_a(this.field_70170_p);
            dragon.getLifeStageController().setLifeStage(LifeStageController.EnumLifeStage.HATCHLING);
            dragon.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            dragon.func_200203_b(this.func_200201_e());
            this.field_70170_p.func_217376_c((Entity)dragon);
        }
        this.func_70106_y();
    }

    public void crack() {
        this.field_70170_p.func_217379_c(2001, this.func_180425_c(), Block.func_196246_j((BlockState)((BlockState)DragonEggBlock.INSTANCE.func_176223_P().func_206870_a(DragonEggBlock.BREED, (Comparable)((Object)this.eggType)))));
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }
}

