/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entity.dragonegg;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.tuple.Pair;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.entity.DMLEntities;
import wolfshotz.dml.entity.dragonegg.DragonEggEntity;
import wolfshotz.dml.entity.dragons.AetherDragonEntity;
import wolfshotz.dml.entity.dragons.EndDragonEntity;
import wolfshotz.dml.entity.dragons.FireDragonEntity;
import wolfshotz.dml.entity.dragons.ForestDragonEntity;
import wolfshotz.dml.entity.dragons.GhostDragonEntity;
import wolfshotz.dml.entity.dragons.IceDragonEntity;
import wolfshotz.dml.entity.dragons.NetherDragonEntity;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;
import wolfshotz.dml.entity.dragons.WaterDragonEntity;
import wolfshotz.dml.item.DragonEggBlockItem;
import wolfshotz.dml.item.DragonSpawnEggItem;

public enum EnumEggTypes implements IStringSerializable
{
    AETHER((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.AETHER_DAGON, AetherDragonEntity::isHabitat, 1169104, 0xFFFF00),
    ENDER((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.ENDER_DRAGON, EndDragonEntity::isHabitat, 0x161616, 16737256),
    NETHER((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.NETHER_DRAGON, NetherDragonEntity::isHabitat, 9511936, 3017472),
    FIRE((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.FIRE_DRAGON, FireDragonEntity::isHabitat, 9511936, 16750617),
    FOREST((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.FOREST_DRAGON, ForestDragonEntity::isHabitat, 346624, 693760),
    GHOST((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.GHOST_DRAGON, GhostDragonEntity::isHabitat, 0xC4C4C4, 12777727),
    ICE((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.ICE_DRAGON, IceDragonEntity::isHabitat, 0xFFFFFF, 47103),
    WATER((Supplier<EntityType<TameableDragonEntity>>)DMLEntities.WATER_DRAGON, WaterDragonEntity::isHabitat, 25343, 0x5999FF);

    public static final EnumEggTypes[] VALUES;
    private final Supplier<EntityType<TameableDragonEntity>> type;
    private final Predicate<DragonEggEntity> habitatCheck;
    private final int primColor;
    private final int secColor;

    private EnumEggTypes(Supplier<EntityType<TameableDragonEntity>> type, Predicate<DragonEggEntity> habitatCheck, int primColor, int secColor) {
        this.type = type;
        this.habitatCheck = habitatCheck;
        this.primColor = primColor;
        this.secColor = secColor;
        DragonMountsLegacy.ITEMS.register(this.func_176610_l() + "_dragon_spawn_egg", () -> new DragonSpawnEggItem(this));
        DragonMountsLegacy.ITEMS.register(this.func_176610_l() + "_dragon_egg", () -> new DragonEggBlockItem(this));
    }

    public static EnumEggTypes getByHabitat(DragonEggEntity egg) {
        return Arrays.stream(VALUES).filter(v -> v.habitatCheck.test(egg)).findFirst().orElse(null);
    }

    public static EnumEggTypes getByType(EntityType<?> type) {
        for (EnumEggTypes value : VALUES) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return AETHER;
    }

    public EntityType<TameableDragonEntity> getType() {
        return this.type.get();
    }

    public Pair<Integer, Integer> getColors() {
        return Pair.of((Object)this.primColor, (Object)this.secColor);
    }

    public float getRColor(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public float getGColor(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    public float getBColor(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color & 0xFF) / 255.0f;
    }

    static {
        VALUES = EnumEggTypes.values();
    }
}

