/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entity.dragons.ai;

import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.BodyController;
import wolfshotz.dml.entity.dragons.TameableDragonEntity;
import wolfshotz.dml.util.MathX;

public class DragonBodyController
extends BodyController {
    private final TameableDragonEntity dragon;
    private int turnTicks;
    private int turnTicksLimit = 20;
    private float prevRotationYawHead;

    public DragonBodyController(TameableDragonEntity dragon) {
        super((MobEntity)dragon);
        this.dragon = dragon;
    }

    public void func_75664_a() {
        double deltaX = this.dragon.func_226277_ct_() - this.dragon.field_70169_q;
        double deltaY = this.dragon.func_226281_cx_() - this.dragon.field_70166_s;
        double dist = deltaX * deltaX + deltaY * deltaY;
        float yawSpeed = 90.0f;
        if (this.dragon.isFlying() || this.dragon.func_70906_o() || dist > 1.0E-4) {
            this.dragon.field_70761_aq = this.dragon.field_70177_z;
            this.prevRotationYawHead = this.dragon.field_70759_as = MathX.updateRotation(this.dragon.field_70761_aq, this.dragon.field_70759_as, yawSpeed);
            this.turnTicks = 0;
            return;
        }
        double yawDiff = Math.abs(this.dragon.field_70759_as - this.prevRotationYawHead);
        if (yawDiff > 15.0) {
            this.turnTicks = 0;
            this.prevRotationYawHead = this.dragon.field_70759_as;
        } else {
            ++this.turnTicks;
            if (this.turnTicks > this.turnTicksLimit) {
                yawSpeed = Math.max(1.0f - (float)(this.turnTicks - this.turnTicksLimit) / (float)this.turnTicksLimit, 0.0f) * 75.0f;
            }
        }
        this.dragon.field_70761_aq = MathX.updateRotation(this.dragon.field_70759_as, this.dragon.field_70761_aq, yawSpeed);
    }
}

