/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.util;

import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MathX {
    public static final double PI_D = Math.PI;
    public static final float PI_F = (float)Math.PI;
    private static final float[][] CR = new float[][]{{-0.5f, 1.5f, -1.5f, 0.5f}, {1.0f, -2.5f, 2.0f, -0.5f}, {-0.5f, 0.0f, 0.5f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}};

    private MathX() {
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float toRadians(float angdeg) {
        return (float)Math.toRadians(angdeg);
    }

    public static float toDegrees(float angrad) {
        return (float)Math.toDegrees(angrad);
    }

    public static float normDeg(float a) {
        if ((a %= 360.0f) >= 180.0f) {
            a -= 360.0f;
        }
        if (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    public static double normDeg(double a) {
        if ((a %= 360.0) >= 180.0) {
            a -= 360.0;
        }
        if (a < -180.0) {
            a += 360.0;
        }
        return a;
    }

    public static float normRad(float a) {
        if ((a %= (float)Math.PI * 2) >= (float)Math.PI) {
            a -= (float)Math.PI * 2;
        }
        if (a < (float)(-Math.PI)) {
            a += (float)Math.PI * 2;
        }
        return a;
    }

    public static double normRad(double a) {
        if ((a %= Math.PI * 2) >= Math.PI) {
            a -= Math.PI * 2;
        }
        if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static float sqrtf(float f) {
        return (float)Math.sqrt(f);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : Math.min(value, max);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }

    public static float updateRotation(float r1, float r2, float step) {
        return r1 + MathX.clamp(MathX.normDeg(r2 - r1), -step, step);
    }

    public static float terpLinear(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        return a * (1.0f - x) + b * x;
    }

    public static float terpSmoothStep(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        x = x * x * (3.0f - 2.0f * x);
        return a * (1.0f - x) + b * x;
    }

    public static void terpCatmullRomSpline(float x, float[] result, float[] ... knots) {
        int nknots = knots.length;
        int nspans = nknots - 3;
        int knot = 0;
        if (nspans < 1) {
            throw new IllegalArgumentException("Spline has too few knots");
        }
        int span = (int)(x = MathX.clamp(x, 0.0f, 0.9999f) * (float)nspans);
        if (span >= nknots - 3) {
            span = nknots - 3;
        }
        x -= (float)span;
        knot += span;
        int dimension = result.length;
        for (int i = 0; i < dimension; ++i) {
            float knot0 = knots[knot][i];
            float knot1 = knots[knot + 1][i];
            float knot2 = knots[knot + 2][i];
            float knot3 = knots[knot + 3][i];
            float c3 = CR[0][0] * knot0 + CR[0][1] * knot1 + CR[0][2] * knot2 + CR[0][3] * knot3;
            float c2 = CR[1][0] * knot0 + CR[1][1] * knot1 + CR[1][2] * knot2 + CR[1][3] * knot3;
            float c1 = CR[2][0] * knot0 + CR[2][1] * knot1 + CR[2][2] * knot2 + CR[2][3] * knot3;
            float c0 = CR[3][0] * knot0 + CR[3][1] * knot1 + CR[3][2] * knot2 + CR[3][3] * knot3;
            result[i] = ((c3 * x + c2) * x + c1) * x + c0;
        }
    }

    public static boolean findBlockstateInArea(World world, AxisAlignedBB area, Block ... blocks) {
        int j1;
        int i = MathHelper.func_76128_c((double)area.field_72340_a);
        int j = MathHelper.func_76143_f((double)area.field_72336_d);
        int k = MathHelper.func_76128_c((double)area.field_72338_b);
        int l = MathHelper.func_76143_f((double)area.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)area.field_72339_c);
        if (world.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)area.field_72334_f))) {
            try (BlockPos.PooledMutable mutable = BlockPos.PooledMutable.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        int i2 = i1;
                        if (i2 >= j1) continue;
                        BlockState blockstate = world.func_180495_p((BlockPos)mutable.func_181079_c(k1, l1, i2));
                        boolean bl = Lists.newArrayList((Object[])blocks).contains(blockstate.func_177230_c());
                        return bl;
                    }
                }
            }
        }
        return false;
    }
}

