/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.mote.ParticleCollection;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class CollectionHelper {
    protected final String name;
    protected final ParticleCollection.ICollectionFactory factory;
    protected final ResourceLocation texture;
    protected WeakReference<ParticleCollection> collection;

    public CollectionHelper(@Nonnull String name, @Nonnull ResourceLocation texture) {
        this(name, ParticleCollection.FACTORY, texture);
    }

    public CollectionHelper(@Nonnull String name, @Nonnull ParticleCollection.ICollectionFactory factory, @Nonnull ResourceLocation texture) {
        this.name = name;
        this.texture = texture;
        this.factory = factory;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public ParticleCollection get() {
        ParticleCollection pc;
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null || !pc.func_187113_k() || pc.shouldDie()) {
            pc = this.factory.create(EnvironStateHandler.EnvironState.getWorld(), this.texture);
            this.collection = new WeakReference<ParticleCollection>(pc);
            ParticleHelper.addParticle((Particle)pc);
        }
        return pc;
    }

    public void clear() {
        ParticleCollection pc;
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc != null) {
            pc.func_187112_i();
            this.collection = null;
        }
    }

    public String toString() {
        ParticleCollection pc;
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append('=');
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null) {
            builder.append("No Collection");
        } else if (!pc.func_187113_k()) {
            builder.append("Expired");
        } else if (pc.shouldDie()) {
            builder.append("Should Die");
        } else {
            builder.append(pc.size());
        }
        return builder.toString();
    }
}

