/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.gui.GuiConstants;
import org.orecruncher.dsurround.client.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.client.sound.MusicFader;
import org.orecruncher.dsurround.client.sound.SoundEngine;

@SideOnly(value=Side.CLIENT)
public class PlaySoundButton
extends GuiButtonExt {
    private final String soundResource;
    private ConfigSoundInstance playingSound;

    public PlaySoundButton(int id, @Nonnull String sound2) {
        super(id, 0, 0, 68, 18, GuiConstants.TEXT_PLAY);
        this.soundResource = sound2;
    }

    public String getSoundResource() {
        return this.soundResource;
    }

    protected void updateDisplayText() {
        this.field_146126_j = this.playingSound != null ? GuiConstants.TEXT_STOP : GuiConstants.TEXT_PLAY;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int x, int y, float partial) {
        if (this.playingSound != null && !SoundEngine.instance().isSoundPlaying(this.playingSound)) {
            this.playingSound = null;
            this.updateDisplayText();
        }
        super.func_191745_a(mc, x, y, partial);
    }

    private void doPlay(@Nonnull ConfigSoundInstance sound2) {
        this.playingSound = sound2;
        MusicFader.playConfigSound(sound2);
    }

    public void playSound(@Nonnull Minecraft mc, float volume) {
        if (this.playingSound != null) {
            MusicFader.stopConfigSound(this.playingSound);
            this.playingSound = null;
        } else {
            this.doPlay(new ConfigSoundInstance(this.soundResource, volume));
        }
        this.updateDisplayText();
    }

    public void stopSound() {
        if (this.playingSound != null) {
            this.playSound(null, 0.0f);
        }
    }
}

