/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.blockartistry.mod.DynSurround.asm.TransformLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer {
    private static final Logger logger = LogManager.getLogger((String)"dsurround Transform");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.client.renderer.EntityRenderer".equals(name) || "blt".equals(name)) {
            logger.debug("Transforming EntityRenderer...");
            return this.transformEntityRenderer(basicClass);
        }
        if ("net.minecraft.world.WorldServer".equals(name) || "mt".equals(name)) {
            logger.debug("Transforming WorldServer...");
            return this.transformWorldServer(basicClass);
        }
        if ("net.minecraft.world.World".equals(name) || "ahb".equals(name)) {
            logger.debug("Transforming World...");
            return this.transformWorld(basicClass);
        }
        if ("net.minecraft.client.audio.SoundManager".equals(name) || "btj".equals(name)) {
            logger.debug("Transforming SoundManager...");
            return this.transformSoundManager(basicClass);
        }
        return basicClass;
    }

    private byte[] transformEntityRenderer(byte[] classBytes) {
        String[] names = TransformLoader.runtimeDeobEnabled ? new String[]{"func_78474_d", "func_78484_h"} : new String[]{"renderRainSnow", "addRainParticles"};
        String[] targetName = new String[]{"renderRainSnow", "addRainParticles"};
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            String sig;
            InsnList list;
            if (m.name.equals(names[0])) {
                logger.debug("Hooking " + names[0]);
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(23, 1));
                sig = "(Lnet/minecraft/client/renderer/EntityRenderer;F)V";
                list.add((AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/mod/DynSurround/client/RenderWeather", targetName[0], "(Lnet/minecraft/client/renderer/EntityRenderer;F)V", false));
                list.add((AbstractInsnNode)new InsnNode(177));
                m.instructions.insertBefore(m.instructions.getFirst(), list);
                continue;
            }
            if (!m.name.equals(names[1])) continue;
            logger.debug("Hooking " + names[1]);
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            sig = "(Lnet/minecraft/client/renderer/EntityRenderer;)V";
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/mod/DynSurround/client/RenderWeather", targetName[1], "(Lnet/minecraft/client/renderer/EntityRenderer;)V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            m.instructions.insertBefore(m.instructions.getFirst(), list);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformWorldServer(byte[] classBytes) {
        String[] names = TransformLoader.runtimeDeobEnabled ? new String[]{"func_73051_P"} : new String[]{"resetRainAndThunder"};
        String[] targetName = new String[]{"resetRainAndThunder"};
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            if (!m.name.equals(names[0])) continue;
            logger.debug("Hooking " + names[0]);
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            String sig = "(Lnet/minecraft/world/WorldServer;)V";
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/mod/DynSurround/server/PlayerSleepHandler", targetName[0], "(Lnet/minecraft/world/WorldServer;)V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            m.instructions.insertBefore(m.instructions.getFirst(), list);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformWorld(byte[] classBytes) {
        String[] names = TransformLoader.runtimeDeobEnabled ? new String[]{"updateWeatherBody"} : new String[]{"updateWeatherBody"};
        String[] targetName = new String[]{"updateWeatherBody"};
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            if (!m.name.equals(names[0])) continue;
            logger.debug("Hooking " + names[0]);
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            String sig = "(Lnet/minecraft/world/World;)V";
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/mod/DynSurround/server/WorldHandler", targetName[0], "(Lnet/minecraft/world/World;)V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            m.instructions.insertBefore(m.instructions.getFirst(), list);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformSoundManager(byte[] classBytes) {
        String[] names = TransformLoader.runtimeDeobEnabled ? new String[]{"func_148594_a"} : new String[]{"getNormalizedVolume"};
        String[] targetName = new String[]{"getNormalizedVolume"};
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode(327680);
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods) {
            if (!m.name.equals(names[0])) continue;
            logger.debug("Hooking " + names[0]);
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            String sig = "(Lnet/minecraft/client/audio/ISound;Lnet/minecraft/client/audio/SoundPoolEntry;Lnet/minecraft/client/audio/SoundCategory;)F";
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/mod/DynSurround/client/sound/SoundManager", targetName[0], "(Lnet/minecraft/client/audio/ISound;Lnet/minecraft/client/audio/SoundPoolEntry;Lnet/minecraft/client/audio/SoundCategory;)F", false));
            list.add((AbstractInsnNode)new InsnNode(174));
            m.instructions.insertBefore(m.instructions.getFirst(), list);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

