/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.BiomeSurveyHandler;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.storm.StormProperties;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.event.DiagnosticEvent;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.PlayerUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FogEffectHandler
implements IClientEffectHandler {
    private static final int HAZE_THRESHOLD = 15;
    private static float currentFogLevel = 0.0f;
    private static float insideFogOffset = 0.0f;
    private static Color currentFogColor = null;

    public static float currentFogLevel() {
        return currentFogLevel;
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    private static float calcHazeBand(World world, EntityPlayer player) {
        float hazeBandRange;
        float distance = MathHelper.func_76135_e((float)((float)DimensionRegistry.getCloudHeight(world) - (float)(player.field_70163_u + (double)player.func_70047_e())));
        if (distance < (hazeBandRange = 15.0f * (1.0f + world.func_72867_j(1.0f) * 2.0f))) {
            return (hazeBandRange - distance) / 50.0f / hazeBandRange * ModOptions.elevationHazeFactor;
        }
        return 0.0f;
    }

    private static float calcHazeGradient(World world, EntityPlayer player) {
        float factor = 1.0f + world.func_72867_j(1.0f);
        float skyHeight = (float)DimensionRegistry.getSkyHeight(world) / factor;
        float groundLevel = DimensionRegistry.getSeaLevel(world);
        float ratio = ((float)MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.func_70047_e())) - groundLevel) / (skyHeight - groundLevel);
        return ratio * ratio * ratio * ratio * ModOptions.elevationHazeFactor;
    }

    @Override
    public void process(World world, EntityPlayer player) {
        currentFogColor = new Color(world.func_72948_g(1.0f));
        float biomeFog = 0.0f;
        float dustFog = 0.0f;
        float heightFog = 0.0f;
        if (ModOptions.enableBiomeFog || ModOptions.allowDesertFog) {
            float brightnessFactor = world.getSunBrightnessBody(1.0f);
            Color tint = new Color(0, 0, 0);
            TObjectIntHashMap<BiomeGenBase> weights = BiomeSurveyHandler.getBiomes();
            int area = BiomeSurveyHandler.getArea();
            for (BiomeGenBase b : weights.keySet()) {
                int weight = weights.get((Object)b);
                float scale = (float)weight / (float)area;
                if (ModOptions.enableBiomeFog && BiomeRegistry.hasFog(b)) {
                    biomeFog += BiomeRegistry.getFogDensity(b) * scale;
                    tint.add(Color.scale(BiomeRegistry.getFogColor(b), brightnessFactor).scale(scale));
                    continue;
                }
                if (ModOptions.allowDesertFog && BiomeRegistry.hasDust(b)) {
                    float str = EnvironStateHandler.EnvironState.getWorld().func_72867_j(1.0f);
                    dustFog += StormProperties.getFogDensity() * scale * str;
                    tint.add(Color.scale(BiomeRegistry.getDustColor(b), brightnessFactor).scale(scale));
                    continue;
                }
                tint.add(Color.scale(currentFogColor, scale));
            }
            currentFogColor = tint;
        }
        biomeFog *= ModOptions.biomeFogFactor;
        dustFog *= ModOptions.desertFogFactor;
        if (ModOptions.enableElevationHaze && DimensionRegistry.hasHaze(world)) {
            heightFog = ModOptions.elevationHazeAsBand ? FogEffectHandler.calcHazeBand(world, player) : FogEffectHandler.calcHazeGradient(world, player);
        }
        currentFogLevel = Math.max(biomeFog, Math.max(dustFog, heightFog));
        insideFogOffset = PlayerUtils.ceilingCoverageRatio(player) * 15.0f;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogColorEvent(EntityViewRenderEvent.FogColors event) {
        if (currentFogColor == null || event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (currentFogLevel == 0.0f) {
            return;
        }
        Block block = ActiveRenderInfo.func_151460_a((World)event.entity.field_70170_p, (EntityLivingBase)event.entity, (float)((float)event.renderPartialTicks));
        if (block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151586_h) {
            return;
        }
        event.red = FogEffectHandler.currentFogColor.red;
        event.green = FogEffectHandler.currentFogColor.green;
        event.blue = FogEffectHandler.currentFogColor.blue;
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (currentFogLevel == 0.0f) {
            return;
        }
        float level = currentFogLevel;
        float factor = 1.0f + level * 100.0f;
        float near = event.farPlaneDistance * 0.75f / (factor * factor) + insideFogOffset;
        float horizon = event.farPlaneDistance / factor + insideFogOffset;
        float start = GL11.glGetFloat((int)2915);
        float end = GL11.glGetFloat((int)2916);
        boolean didFog = false;
        if (near < start) {
            GL11.glFogf((int)2915, (float)near);
            didFog = true;
        }
        if (horizon < end) {
            GL11.glFogf((int)2916, (float)horizon);
            didFog = true;
        }
        if (didFog) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void diagnostics(DiagnosticEvent.Gather event) {
        StringBuilder builder = new StringBuilder();
        builder.append("Fog:");
        builder.append(" c:").append(currentFogLevel);
        event.output.add(builder.toString());
    }
}

