/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.BiomeSurveyHandler;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SoundManager;
import org.blockartistry.mod.DynSurround.client.storm.StormProperties;
import org.blockartistry.mod.DynSurround.compat.BlockPos;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.event.DiagnosticEvent;
import org.blockartistry.mod.DynSurround.event.RegistryReloadEvent;

@SideOnly(value=Side.CLIENT)
public class PlayerSoundEffectHandler
implements IClientEffectHandler {
    private static final List<EntityDropParticleFX> drops = new ArrayList<EntityDropParticleFX>();

    private static boolean doBiomeSounds() {
        return EnvironStateHandler.EnvironState.isPlayerUnderground() || !EnvironStateHandler.EnvironState.isPlayerInside();
    }

    private static List<SoundEffect> getBiomeSounds(String conditions) {
        TObjectIntHashMap sounds = new TObjectIntHashMap();
        TObjectIntHashMap<BiomeGenBase> weights = BiomeSurveyHandler.getBiomes();
        for (BiomeGenBase biome : weights.keySet()) {
            List<SoundEffect> bs = BiomeRegistry.getSounds(biome, conditions);
            for (SoundEffect sound : bs) {
                sounds.put((Object)sound, sounds.get((Object)sound) + weights.get((Object)biome));
            }
        }
        ArrayList<SoundEffect> result = new ArrayList<SoundEffect>();
        int area = BiomeSurveyHandler.getArea();
        for (SoundEffect sound : sounds.keySet()) {
            float scale = 0.3f + 0.7f * ((float)sounds.get((Object)sound) / (float)area);
            result.add(SoundEffect.scaleVolume(sound, scale));
        }
        return result;
    }

    private static void resetSounds() {
        SoundManager.clearSounds();
        drops.clear();
    }

    @Override
    public void process(World world, EntityPlayer player) {
        SoundEffect sound;
        if (player.field_70128_L) {
            PlayerSoundEffectHandler.resetSounds();
            return;
        }
        BiomeGenBase playerBiome = EnvironStateHandler.EnvironState.getPlayerBiome();
        String conditions = EnvironStateHandler.EnvironState.getConditions();
        ArrayList<SoundEffect> sounds = new ArrayList<SoundEffect>();
        if (PlayerSoundEffectHandler.doBiomeSounds()) {
            sounds.addAll(PlayerSoundEffectHandler.getBiomeSounds(conditions));
        }
        sounds.addAll(BiomeRegistry.getSounds(BiomeRegistry.PLAYER, conditions));
        SoundManager.queueAmbientSounds(sounds);
        if (PlayerSoundEffectHandler.doBiomeSounds() && (sound = BiomeRegistry.getSpotSound(playerBiome, conditions, EnvironStateHandler.EnvironState.RANDOM)) != null) {
            SoundManager.playSoundAtPlayer(player, sound);
        }
        if ((sound = BiomeRegistry.getSpotSound(BiomeRegistry.PLAYER, conditions, EnvironStateHandler.EnvironState.RANDOM)) != null) {
            SoundManager.playSoundAtPlayer(player, sound);
        }
        this.processWaterDrops();
        SoundManager.update();
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    @SubscribeEvent
    public void registryReloadEvent(RegistryReloadEvent.Biome event) {
        PlayerSoundEffectHandler.resetSounds();
    }

    @SubscribeEvent
    public void playerJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.entity.field_70170_p.field_72995_K && EnvironStateHandler.EnvironState.isPlayer(event.entity)) {
            PlayerSoundEffectHandler.resetSounds();
        }
    }

    @SubscribeEvent
    public void diagnostics(DiagnosticEvent.Gather event) {
        StringBuilder builder = new StringBuilder();
        builder.append("SoundSystem: ").append(SoundManager.currentSoundCount()).append('/').append(SoundManager.maxSoundCount());
        event.output.add(builder.toString());
        for (String sound : SoundManager.getSounds()) {
            event.output.add(sound);
        }
    }

    @SubscribeEvent
    public void entityCreateEvent(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityDropParticleFX) {
            drops.add((EntityDropParticleFX)event.entity);
        }
    }

    private void processWaterDrops() {
        if (drops.isEmpty()) {
            return;
        }
        World world = EnvironStateHandler.EnvironState.getWorld();
        for (EntityDropParticleFX drop : drops) {
            int soundY;
            int z;
            int y;
            int x;
            Block block;
            if (!drop.func_70089_S() || drop.field_70163_u < 1.0 || (block = world.func_147439_a(x = MathHelper.func_76128_c((double)drop.field_70165_t), y = MathHelper.func_76128_c((double)(drop.field_70163_u + 0.3)), z = MathHelper.func_76128_c((double)drop.field_70161_v))) == Blocks.field_150350_a || block.isLeaves((IBlockAccess)world, x, y, z)) continue;
            for (soundY = y - 1; soundY > 0 && (block = world.func_147439_a(x, soundY, z)) == Blocks.field_150350_a; --soundY) {
            }
            if (soundY <= 0 || !block.func_149688_o().func_76220_a()) continue;
            int distance = y - soundY;
            SoundManager.playSoundAt(new BlockPos(x, soundY + 1, z), BiomeRegistry.WATER_DRIP, 40 + distance * 2);
        }
        drops.clear();
    }

    private static boolean replaceRainSound(String name) {
        return "ambient.weather.rain".equals(name);
    }

    @SubscribeEvent
    public void soundEvent(PlaySoundEvent17 event) {
        if (event.sound == null) {
            return;
        }
        if ((ModOptions.alwaysOverrideSound || !StormProperties.doVanilla()) && PlayerSoundEffectHandler.replaceRainSound(event.name)) {
            ISound sound = event.sound;
            event.result = new PositionedSoundRecord(StormProperties.getCurrentStormSound(), StormProperties.getCurrentVolume(), sound.func_147655_f(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        }
    }
}

