/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.data.SoundRegistry;
import org.blockartistry.mod.DynSurround.event.SoundConfigEvent;

@SideOnly(value=Side.CLIENT)
public class SoundBlockHandler
implements IClientEffectHandler {
    private final List<String> soundsToBlock = new ArrayList<String>();
    private final TObjectIntHashMap<String> soundCull = new TObjectIntHashMap();

    @Override
    public void process(World world, EntityPlayer player) {
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    @SubscribeEvent
    public void soundConfigReload(SoundConfigEvent.Reload event) {
        this.soundsToBlock.clear();
        this.soundCull.clear();
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        for (Object resource : handler.field_147697_e.func_148742_b()) {
            String rs = resource.toString();
            if (SoundRegistry.isSoundBlocked(rs)) {
                ModLog.debug("Blocking sound '%s'", rs);
                this.soundsToBlock.add(rs);
                continue;
            }
            if (!SoundRegistry.isSoundCulled(rs)) continue;
            ModLog.debug("Culling sound '%s'", rs);
            this.soundCull.put((Object)rs, -ModOptions.soundCullingThreshold);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void soundEvent(PlaySoundEvent17 event) {
        if (event.sound == null) {
            return;
        }
        String resource = event.sound.func_147650_b().toString();
        if (this.soundsToBlock.contains(resource)) {
            event.result = null;
            return;
        }
        if (ModOptions.soundCullingThreshold <= 0) {
            return;
        }
        int lastOccurance = this.soundCull.get((Object)resource);
        if (lastOccurance == 0) {
            return;
        }
        int currentTick = EnvironStateHandler.EnvironState.getTickCounter();
        if (currentTick - lastOccurance < ModOptions.soundCullingThreshold) {
            event.result = null;
        } else {
            this.soundCull.put((Object)resource, currentTick);
        }
    }
}

