/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.aurora;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.AuroraEffectHandler;
import org.blockartistry.mod.DynSurround.client.IAtmosRenderer;
import org.blockartistry.mod.DynSurround.client.aurora.Aurora;
import org.blockartistry.mod.DynSurround.client.aurora.Node;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.DiurnalUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class AuroraRenderer
implements IAtmosRenderer {
    @Override
    public void render(EntityRenderer renderer, float partialTick) {
        if (AuroraEffectHandler.currentAurora != null) {
            AuroraRenderer.renderAurora(partialTick, AuroraEffectHandler.currentAurora);
        }
    }

    private static void setColor(Color color, float alpha) {
        Tessellator.field_78398_a.func_78369_a(color.red, color.green, color.blue, alpha);
    }

    public static float moonlightFactor(World world) {
        float moonFactor = 1.0f - DiurnalUtils.getMoonPhaseFactor(world) * 1.1f;
        if (moonFactor <= 0.0f) {
            return 0.0f;
        }
        return MathHelper.func_76131_a((float)(moonFactor * moonFactor), (float)0.0f, (float)1.0f);
    }

    public static void renderAurora(float partialTick, Aurora aurora) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        float alpha = (float)aurora.getAlpha() * AuroraRenderer.moonlightFactor((World)mc.field_71441_e) / 255.0f;
        if (alpha <= 0.0f) {
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        float tranY = ModOptions.auroraHeightPlayerRelative ? ModOptions.playerFixedHeight : (float)(DimensionRegistry.getCloudHeight((World)mc.field_71441_e) + 5) - (float)(mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTick);
        double tranX = (double)aurora.posX - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
        double tranZ = (double)aurora.posZ - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
        if (ModOptions.auroraAnimate) {
            aurora.translate(partialTick);
        }
        Color base = aurora.getBaseColor();
        Color fade = aurora.getFadeColor();
        double lowY = 0.0;
        double lowY2 = 0.0;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)tranX), (float)tranY, (float)((float)tranZ));
        GL11.glScaled((double)0.5, (double)8.0, (double)0.5);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        for (Node[] array : aurora.getNodeList()) {
            for (int i = 0; i < array.length - 1; ++i) {
                double posY2;
                double tetZ2;
                double tetX2;
                double posZ2;
                double posX2;
                Node node = array[i];
                double posY = node.getModdedY();
                double posX = node.tetX;
                double posZ = node.tetZ;
                double tetX = node.tetX2;
                double tetZ = node.tetZ2;
                if (i < array.length - 2) {
                    Node nodePlus = array[i + 1];
                    posX2 = nodePlus.tetX;
                    posZ2 = nodePlus.tetZ;
                    tetX2 = nodePlus.tetX2;
                    tetZ2 = nodePlus.tetZ2;
                    posY2 = nodePlus.getModdedY();
                } else {
                    posX2 = tetX2 = (double)node.posX;
                    posZ2 = tetZ2 = (double)node.getModdedZ();
                    posY2 = 0.0;
                }
                tess.func_78371_b(6);
                AuroraRenderer.setColor(base, alpha);
                tess.func_78377_a(posX, 0.0, posZ);
                AuroraRenderer.setColor(fade, 0.0f);
                tess.func_78377_a(posX, posY, posZ);
                tess.func_78377_a(posX2, posY2, posZ2);
                AuroraRenderer.setColor(base, alpha);
                tess.func_78377_a(posX2, 0.0, posZ2);
                tess.func_78381_a();
                tess.func_78371_b(6);
                AuroraRenderer.setColor(base, alpha);
                tess.func_78377_a(posX, 0.0, posZ);
                tess.func_78377_a(posX2, 0.0, posZ2);
                tess.func_78377_a(tetX2, 0.0, tetZ2);
                tess.func_78377_a(tetX, 0.0, tetZ);
                tess.func_78381_a();
                tess.func_78371_b(6);
                AuroraRenderer.setColor(base, alpha);
                tess.func_78377_a(tetX, 0.0, tetZ);
                AuroraRenderer.setColor(fade, 0.0f);
                tess.func_78377_a(tetX, posY, tetZ);
                tess.func_78377_a(tetX2, posY2, tetZ2);
                AuroraRenderer.setColor(base, alpha);
                tess.func_78377_a(tetX2, 0.0, tetZ2);
                tess.func_78381_a();
            }
        }
        GL11.glScaled((double)3.5, (double)25.0, (double)3.5);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
    }
}

