/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.aurora;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.blockartistry.mod.DynSurround.util.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class Node {
    private static final float COS_DEG90_FACTOR = MathStuff.cos(1.5707964f);
    private static final float COS_DEG270_FACTOR = MathStuff.cos(4.712389f);
    private static final float SIN_DEG90_FACTOR = MathStuff.sin(1.5707964f);
    private static final float SIN_DEG270_FACTOR = MathStuff.sin(4.712389f);
    private float dZ = 0.0f;
    private float dY = 0.0f;
    private float cosDeg90 = 0.0f;
    private float cosDeg270 = 0.0f;
    private float sinDeg90 = 0.0f;
    private float sinDeg270 = 0.0f;
    public float angle;
    public float posX;
    public float posY;
    public float posZ;
    public float tetX = 0.0f;
    public float tetX2 = 0.0f;
    public float tetZ = 0.0f;
    public float tetZ2 = 0.0f;
    private static final float COEFF_1 = 0.7853982f;
    private static final float COEFF_2 = 2.3561945f;
    private static final float CONST = 1.0E-10f;

    public Node(Node template, int offset) {
        float rads = MathStuff.toRadians(90.0f + template.angle);
        this.posX = template.posX + MathStuff.cos(rads) * (float)offset;
        this.posY = template.posY - 2.0f;
        this.posZ = template.posZ + MathStuff.sin(rads) * (float)offset;
        this.angle = template.angle;
    }

    public Node(float x, float y, float z, float theta) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.angle = theta;
    }

    private static final float atan2_fast(float y, float x) {
        float abs_y = MathStuff.abs(y) + 1.0E-10f;
        float angle = x >= 0.0f ? 0.7853982f - 0.7853982f * (x - abs_y) / (x + abs_y) : 2.3561945f - 2.3561945f * (x + abs_y) / (abs_y - x);
        return (double)y < 0.0 ? -angle : angle;
    }

    public void setDeltaZ(float f) {
        this.dZ = f;
    }

    public void setDeltaY(float f) {
        this.dY = f;
    }

    public float getModdedZ() {
        return this.posZ + this.dZ;
    }

    public float getModdedY() {
        float y = this.posY + this.dY;
        return y < 0.0f ? 0.0f : y;
    }

    public void setWidth(float w) {
        this.cosDeg270 = COS_DEG270_FACTOR * w;
        this.cosDeg90 = COS_DEG90_FACTOR * w;
        this.sinDeg270 = SIN_DEG270_FACTOR * w;
        this.sinDeg90 = SIN_DEG90_FACTOR * w;
    }

    public void findAngles(Node next) {
        this.tetX = this.tetX2 = this.posX;
        this.tetZ = this.tetZ2 = this.getModdedZ();
        this.angle = 0.0f;
        if (next != null) {
            this.angle = Node.atan2_fast(this.getModdedZ() - next.getModdedZ(), this.posX - next.posX);
            this.tetX += this.cosDeg90;
            this.tetX2 += this.cosDeg270;
            this.tetZ += this.sinDeg90;
            this.tetZ2 += this.sinDeg270;
        }
    }
}

