/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.ForgeDictionary;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.PFIsolator;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.PFReaderH;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.PFResourcePackDealer;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.PFSolver;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.UserConfigSoundPlayerWrapper;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.AcousticsManager;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.BasicPrimitiveMap;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.LegacyCapableBlockMap;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.NormalVariator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IBlockMap;
import org.blockartistry.mod.DynSurround.client.footsteps.parsers.AcousticsJsonReader;
import org.blockartistry.mod.DynSurround.client.footsteps.parsers.Register;
import org.blockartistry.mod.DynSurround.client.footsteps.util.property.simple.ConfigProperty;

@SideOnly(value=Side.CLIENT)
public class Footsteps
implements IResourceManagerReloadListener,
IClientEffectHandler {
    public static Footsteps INSTANCE = null;
    private PFResourcePackDealer dealer = new PFResourcePackDealer();
    private PFIsolator isolator;

    public Footsteps() {
        INSTANCE = this;
    }

    public void reloadEverything() {
        this.isolator = new PFIsolator();
        List<IResourcePack> repo = this.dealer.findResourcePacks();
        this.reloadBlockMap(repo);
        this.reloadPrimitiveMap(repo);
        this.reloadAcoustics(repo);
        this.isolator.setSolver(new PFSolver(this.isolator));
        this.reloadVariator(repo);
        this.isolator.setGenerator(new PFReaderH(this.isolator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadVariator(List<IResourcePack> repo) {
        NormalVariator var = new NormalVariator();
        for (IResourcePack pack : repo) {
            InputStream stream = null;
            try {
                stream = this.dealer.openVariator(pack);
                if (stream == null) continue;
                var.loadConfig(ConfigProperty.fromStream(stream));
            }
            catch (Exception e) {
                ModLog.debug("Unable to load variator data from pack %s", pack.func_130077_b());
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isolator.setVariator(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadBlockMap(List<IResourcePack> repo) {
        LegacyCapableBlockMap blockMap = new LegacyCapableBlockMap();
        ForgeDictionary.initialize(blockMap);
        for (IResourcePack pack : repo) {
            InputStream stream = null;
            try {
                stream = this.dealer.openBlockMap(pack);
                if (stream == null) continue;
                Register.setup(ConfigProperty.fromStream(stream), blockMap);
            }
            catch (IOException e) {
                ModLog.debug("Unable to load block map data from pack %s", pack.func_130077_b());
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isolator.setBlockMap(blockMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPrimitiveMap(List<IResourcePack> repo) {
        BasicPrimitiveMap primitiveMap = new BasicPrimitiveMap();
        for (IResourcePack pack : repo) {
            InputStream stream = null;
            try {
                stream = this.dealer.openPrimitiveMap(pack);
                if (stream == null) continue;
                Register.setup(ConfigProperty.fromStream(stream), primitiveMap);
            }
            catch (IOException e) {
                ModLog.debug("Unable to load primitive map data from pack %s", pack.func_130077_b());
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isolator.setPrimitiveMap(primitiveMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAcoustics(List<IResourcePack> repo) {
        AcousticsManager acoustics = new AcousticsManager(this.isolator);
        Scanner scanner = null;
        InputStream stream = null;
        for (IResourcePack pack : repo) {
            try {
                stream = this.dealer.openAcoustics(pack);
                if (stream == null) continue;
                scanner = new Scanner(stream);
                String jasonString = scanner.useDelimiter("\\Z").next();
                new AcousticsJsonReader("").parseJSON(jasonString, acoustics);
            }
            catch (IOException e) {
                ModLog.debug("Unable to load acoustic data from pack %s", pack.func_130077_b());
            }
            finally {
                try {
                    if (scanner != null) {
                        scanner.close();
                    }
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isolator.setAcoustics(acoustics);
        this.isolator.setSoundPlayer(new UserConfigSoundPlayerWrapper(acoustics));
        this.isolator.setDefaultStepPlayer(acoustics);
    }

    public void func_110549_a(IResourceManager var1) {
        ModLog.info("Resource Pack reload detected...", new Object[0]);
        this.reloadEverything();
    }

    @Override
    public void process(World world, EntityPlayer player) {
        if (this.isolator == null) {
            this.reloadEverything();
        }
        this.isolator.onFrame();
        player.field_70150_b = Integer.MAX_VALUE;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            this.isolator = null;
        }
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    public IBlockMap getBlockMap() {
        return this.isolator.getBlockMap();
    }
}

