/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IBlockMap;
import org.blockartistry.mod.DynSurround.compat.MCHelper;

@SideOnly(value=Side.CLIENT)
public class BasicBlockMap
implements IBlockMap {
    private static final Pattern pattern = Pattern.compile("([^:]+:[^^+]+)\\^?(\\d+)?\\+?(\\w+)?");
    private final Map<Block, TIntObjectHashMap<String>> metaMap = new TCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    private final Map<Block, Map<String, String>> substrateMap = new TCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    private static final Map<String, List<MacroEntry>> macros = new LinkedHashMap<String, List<MacroEntry>>();

    @Override
    public String getBlockMap(Block block, int meta) {
        TIntObjectHashMap<String> metas = this.metaMap.get(block);
        if (metas != null) {
            String result = (String)metas.get(meta);
            if (result == null) {
                result = (String)metas.get(-1);
            }
            return result;
        }
        return null;
    }

    @Override
    public String getBlockMapSubstrate(Block block, int meta, String substrate) {
        Map<String, String> sub = this.substrateMap.get(block);
        if (sub != null) {
            String result = sub.get(substrate + "." + meta);
            if (result == null) {
                result = sub.get(substrate + ".-1");
            }
            return result;
        }
        return null;
    }

    private void put(Block block, int meta, String substrate, String value) {
        if (StringUtils.isEmpty((CharSequence)substrate)) {
            TIntObjectHashMap metas = this.metaMap.get(block);
            if (metas == null) {
                metas = new TIntObjectHashMap();
                this.metaMap.put(block, (TIntObjectHashMap<String>)metas);
            }
            metas.put(meta, (Object)value);
        } else {
            Map<String, String> sub = this.substrateMap.get(block);
            if (sub == null) {
                sub = new HashMap<String, String>();
                this.substrateMap.put(block, sub);
            }
            sub.put(substrate + "." + meta, value);
        }
    }

    private void expand(Block block, String value) {
        List<MacroEntry> macro = macros.get(value);
        if (macro != null) {
            for (MacroEntry entry : macro) {
                this.put(block, entry.meta, entry.substrate, entry.value);
            }
        } else {
            ModLog.debug("Unknown macro '%s'", value);
        }
    }

    @Override
    public void register(String key, String value) {
        Matcher matcher = pattern.matcher(key);
        if (matcher.matches()) {
            String blockName = matcher.group(1);
            Block block = MCHelper.getBlockNameRaw(blockName);
            if (block != null) {
                int meta = matcher.group(2) == null ? -1 : Integer.parseInt(matcher.group(2));
                String substrate = matcher.group(3);
                if (value.startsWith("#")) {
                    this.expand(block, value);
                } else {
                    this.put(block, meta, substrate, value);
                }
            } else {
                ModLog.debug("Unable to locate block for blockmap '%s'", blockName);
            }
        } else {
            ModLog.debug("Malformed key in blockmap '%s'", key);
        }
    }

    @Override
    public boolean hasEntryForBlock(Block block) {
        return this.metaMap.containsKey(block) || this.substrateMap.containsKey(block);
    }

    @Override
    public void collectData(Block block, int meta, List<String> data) {
        Map<String, String> subs;
        String temp = this.getBlockMap(block, meta);
        if (temp != null) {
            data.add(temp);
        }
        if ((subs = this.substrateMap.get(block)) != null) {
            int len = data.size();
            temp = "." + meta;
            for (Map.Entry<String, String> entry : subs.entrySet()) {
                if (!entry.getKey().endsWith(temp)) continue;
                data.add(entry.getValue());
            }
            if (data.size() == len) {
                temp = ".-1";
                for (Map.Entry<String, String> entry : subs.entrySet()) {
                    if (!entry.getKey().endsWith(temp)) continue;
                    data.add(entry.getKey() + ":" + entry.getValue());
                }
            }
        }
    }

    static {
        ArrayList<MacroEntry> entries = new ArrayList<MacroEntry>();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#sapling", entries);
        macros.put("#reed", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "brush"));
        entries.add(new MacroEntry(3, "foliage", "brush"));
        entries.add(new MacroEntry(4, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(5, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(6, "foliage", "straw"));
        entries.add(new MacroEntry(7, "foliage", "straw"));
        macros.put("#wheat", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(3, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(4, "foliage", "brush"));
        entries.add(new MacroEntry(5, "foliage", "brush"));
        entries.add(new MacroEntry(6, "foliage", "brush"));
        entries.add(new MacroEntry(7, "foliage", "brush"));
        macros.put("#crop", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry("bigger", "bluntwood"));
        macros.put("#fence", entries);
    }

    private static class MacroEntry {
        public final int meta;
        public final String substrate;
        public final String value;

        public MacroEntry(String substrate, String value) {
            this(-1, substrate, value);
        }

        public MacroEntry(int meta, String substrate, String value) {
            this.meta = meta;
            this.substrate = substrate;
            this.value = value;
        }
    }
}

