/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.hud;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.hud.DebugHUD;
import org.blockartistry.mod.DynSurround.client.hud.PotionHUD;

@SideOnly(value=Side.CLIENT)
public final class GuiHUDHandler {
    private static final List<IGuiOverlay> overlays = new ArrayList<IGuiOverlay>();

    private GuiHUDHandler() {
    }

    public static void register(IGuiOverlay overlay) {
        overlays.add(overlay);
    }

    public static void initialize() {
        if (ModOptions.enableDebugLogging) {
            GuiHUDHandler.register(new DebugHUD());
        }
        if (ModOptions.potionHudEnabled) {
            GuiHUDHandler.register(new PotionHUD());
        }
        MinecraftForge.EVENT_BUS.register((Object)new GuiHUDHandler());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        for (IGuiOverlay overlay : overlays) {
            overlay.doRender(event);
        }
    }

    public static interface IGuiOverlay {
        public void doRender(RenderGameOverlayEvent var1);
    }
}

