/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.sound.PlayerSound;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SoundManager;
import org.blockartistry.mod.DynSurround.util.XorShiftRandom;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
class Emitter {
    protected static final Random RANDOM = new XorShiftRandom();
    protected final SoundEffect effect;
    protected PlayerSound activeSound;
    protected int repeatDelay = 0;

    public Emitter(SoundEffect sound) {
        this.effect = sound;
    }

    public void update() {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        if (this.activeSound != null) {
            if (handler.func_147692_c((ISound)this.activeSound)) {
                return;
            }
            ModLog.debug("FADE: " + this.activeSound.toString(), new Object[0]);
            this.activeSound.fadeAway();
            this.activeSound = null;
            this.repeatDelay = this.effect.getRepeat(RANDOM);
            if (this.repeatDelay > 0) {
                return;
            }
        } else if (this.repeatDelay > 0 && --this.repeatDelay > 0) {
            return;
        }
        if (SoundSystemConfig.getMasterGain() <= 0.0f) {
            return;
        }
        PlayerSound theSound = new PlayerSound(this.effect);
        if (this.effect.type == SoundEffect.SoundType.PERIODIC) {
            this.repeatDelay = this.effect.getRepeat(RANDOM);
        } else {
            this.activeSound = theSound;
        }
        try {
            SoundManager.playSound((ISound)theSound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setVolume(float volume) {
        if (this.activeSound != null) {
            this.activeSound.setVolume(volume);
        }
    }

    public float getVolume() {
        return this.activeSound != null ? this.activeSound.func_147653_e() : 0.0f;
    }

    public void fade() {
        if (this.activeSound != null) {
            this.activeSound.fadeAway();
        }
    }
}

