/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.util.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
class PlayerSound
extends MovingSound {
    private static final float DONE_VOLUME_THRESHOLD = 0.001f;
    private static final float FADE_AMOUNT = 0.01f;
    private static final Random RANDOM = new XorShiftRandom();
    private final SoundEffect sound;
    private boolean isFading;

    public PlayerSound(SoundEffect sound) {
        super(new ResourceLocation(sound.sound));
        this.sound = sound;
        this.field_147662_b = sound.volume;
        this.field_147663_c = sound.getPitch(RANDOM);
        this.field_147659_g = sound.repeatDelay == 0;
        this.field_147665_h = 0;
        EntityPlayer player = EnvironStateHandler.EnvironState.getPlayer();
        this.field_147660_d = MathHelper.func_76128_c((double)player.field_70165_t);
        this.field_147661_e = MathHelper.func_76128_c((double)(player.field_70163_u + 1.0));
        this.field_147658_f = MathHelper.func_76128_c((double)player.field_70161_v);
    }

    public void fadeAway() {
        this.isFading = true;
    }

    public boolean sameSound(SoundEffect snd) {
        return this.sound.equals(snd);
    }

    public void func_73660_a() {
        if (this.field_147668_j) {
            return;
        }
        if (this.isFading) {
            this.field_147662_b -= 0.01f;
        }
        if (this.field_147662_b <= 0.001f) {
            this.field_147668_j = true;
        } else if (EnvironStateHandler.EnvironState.getPlayer() != null) {
            EntityPlayer player = EnvironStateHandler.EnvironState.getPlayer();
            this.field_147660_d = MathHelper.func_76128_c((double)player.field_70165_t);
            this.field_147661_e = MathHelper.func_76128_c((double)(player.field_70163_u + 1.0));
            this.field_147658_f = MathHelper.func_76128_c((double)player.field_70161_v);
        }
    }

    public float func_147653_e() {
        return this.field_147662_b * ModOptions.masterSoundScaleFactor;
    }

    public void setVolume(float volume) {
        if (volume < this.field_147662_b || !this.isFading) {
            this.field_147662_b = volume;
        }
    }

    public String toString() {
        return this.sound.toString();
    }

    public boolean equals(Object anObj) {
        if (this == anObj) {
            return true;
        }
        if (anObj instanceof PlayerSound) {
            return this.sameSound(((PlayerSound)((Object)anObj)).sound);
        }
        if (anObj instanceof SoundEffect) {
            return this.sameSound((SoundEffect)anObj);
        }
        return false;
    }
}

