/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.sound.Emitter;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SpotSound;
import org.blockartistry.mod.DynSurround.compat.BlockPos;
import org.blockartistry.mod.DynSurround.data.SoundRegistry;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class SoundManager {
    private static final int AGE_THRESHOLD_TICKS = 5;
    private static final int SOUND_QUEUE_SLACK = 6;
    private static final Map<SoundEffect, Emitter> emitters = new HashMap<SoundEffect, Emitter>();
    private static final List<SpotSound> pending = new ArrayList<SpotSound>();

    public static void clearSounds() {
        for (Emitter emit : emitters.values()) {
            emit.fade();
        }
        emitters.clear();
        pending.clear();
    }

    public static void queueAmbientSounds(List<SoundEffect> sounds) {
        ArrayList<SoundEffect> active = new ArrayList<SoundEffect>(emitters.keySet());
        for (SoundEffect effect : active) {
            if (!sounds.contains(effect)) {
                emitters.remove(effect).fade();
                continue;
            }
            Emitter emitter = emitters.get(effect);
            SoundEffect incoming = null;
            for (SoundEffect sound : sounds) {
                if (!sound.equals(effect)) continue;
                incoming = sound;
                break;
            }
            emitter.setVolume(incoming.getVolume());
            sounds.remove(effect);
        }
        for (SoundEffect sound : sounds) {
            emitters.put(sound, new Emitter(sound));
        }
    }

    public static void update() {
        for (Emitter emitter : emitters.values()) {
            emitter.update();
        }
        Iterator<SpotSound> pitr = pending.iterator();
        while (pitr.hasNext()) {
            SpotSound sound = pitr.next();
            if (sound.getTickAge() >= 5) {
                ModLog.debug("AGING: " + sound.toString(), new Object[0]);
                pitr.remove();
                continue;
            }
            if (sound.getTickAge() < 0 || !SoundManager.canFitSound()) continue;
            SoundManager.playSound((ISound)sound);
            pitr.remove();
        }
    }

    public static int currentSoundCount() {
        return Minecraft.func_71410_x().func_147118_V().field_147694_f.field_148629_h.size();
    }

    public static int maxSoundCount() {
        return SoundSystemConfig.getNumberNormalChannels() + SoundSystemConfig.getNumberStreamingChannels();
    }

    private static boolean canFitSound() {
        return SoundManager.currentSoundCount() < SoundSystemConfig.getNumberNormalChannels() - 6;
    }

    static void playSound(ISound sound) {
        if (sound != null) {
            if (ModOptions.enableDebugLogging) {
                ModLog.debug("PLAYING: " + sound.toString(), new Object[0]);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
        }
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEffect sound) {
        if (player == null) {
            player = EnvironStateHandler.EnvironState.getPlayer();
        }
        SpotSound s = new SpotSound(player, sound);
        if (!SoundManager.canFitSound()) {
            pending.add(s);
        } else {
            SoundManager.playSound((ISound)s);
        }
    }

    public static void playSoundAt(BlockPos pos, SoundEffect sound, int tickDelay) {
        if (tickDelay > 0 && !SoundManager.canFitSound()) {
            return;
        }
        SpotSound s = new SpotSound(pos, sound, tickDelay);
        if (tickDelay > 0 || !SoundManager.canFitSound()) {
            pending.add(s);
        } else {
            SoundManager.playSound((ISound)s);
        }
    }

    public static List<String> getSounds() {
        ArrayList<String> result = new ArrayList<String>();
        for (SoundEffect soundEffect : emitters.keySet()) {
            result.add("EMITTER: " + soundEffect.toString() + "[vol:" + emitters.get(soundEffect).getVolume() + "]");
        }
        for (SpotSound spotSound : pending) {
            result.add((spotSound.getTickAge() < 0 ? "DELAYED: " : "PENDING: ") + spotSound.getSoundEffect().toString());
        }
        return result;
    }

    public static void configureSound() {
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int normalChannels = ModOptions.normalSoundChannelCount;
        int streamChannels = ModOptions.streamingSoundChannelCount;
        if (ModOptions.autoConfigureChannels && totalChannels > 64) {
            int maxCount = Math.max((totalChannels + 1) / 2, 32);
            normalChannels = MathHelper.func_76141_d((float)((float)maxCount * 0.875f));
            streamChannels = maxCount - normalChannels;
        }
        ModLog.info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannels, streamChannels, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannels);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannels);
    }

    public static float getNormalizedVolume(ISound sound, SoundPoolEntry poolEntry, SoundCategory category) {
        float result = 0.0f;
        if (sound == null) {
            ModLog.warn("getNormalizedVolume(): Null sound parameter", new Object[0]);
        } else if (poolEntry == null) {
            ModLog.warn("getNormalizedVolume(): Null poolEntry parameter", new Object[0]);
        } else if (category == null) {
            ModLog.warn("getNormalizedVolume(): Null category parameter", new Object[0]);
        } else {
            String soundName = sound.func_147650_b().toString();
            try {
                float volumeScale = SoundRegistry.getVolumeScale(soundName);
                result = (float)MathHelper.func_151237_a((double)((double)sound.func_147653_e() * poolEntry.func_148649_c() * (double)SoundManager.getSoundCategoryVolume(category) * (double)volumeScale), (double)0.0, (double)1.0);
            }
            catch (Throwable t) {
                ModLog.error("getNormalizedVolume(): Unable to calculate " + soundName, t);
            }
        }
        return result;
    }

    public static float getSoundCategoryVolume(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? Minecraft.func_71410_x().field_71474_y.func_151438_a(category) : 1.0f;
    }
}

