/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.storm;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.storm.StormRenderer;

@SideOnly(value=Side.CLIENT)
public enum StormProperties {
    VANILLA,
    NONE(0.0f, "calm"),
    CALM(0.1f, "calm"),
    LIGHT(0.33f, "light"),
    NORMAL(0.66f, "normal"),
    HEAVY(1.0f, "heavy");

    private static float intensityLevel;
    private static StormProperties intensity;
    private static float fogDensity;
    private final float level;
    private final ResourceLocation rainTexture;
    private final ResourceLocation snowTexture;
    private final ResourceLocation dustTexture;
    private final String rainSound;
    private final String dustSound;

    private StormProperties() {
        this.level = -10.0f;
        this.rainTexture = EntityRenderer.field_110924_q;
        this.snowTexture = EntityRenderer.field_110923_r;
        this.dustTexture = new ResourceLocation("dsurround", "textures/environment/dust_calm.png");
        this.rainSound = String.format("%s:%s", "dsurround", "rain");
        this.dustSound = String.format("%s:%s", "dsurround", "dust");
    }

    private StormProperties(float level, String intensity) {
        this.level = level;
        this.rainTexture = new ResourceLocation("dsurround", String.format("textures/environment/rain_%s.png", intensity));
        this.snowTexture = new ResourceLocation("dsurround", String.format("textures/environment/snow_%s.png", intensity));
        this.dustTexture = new ResourceLocation("dsurround", String.format("textures/environment/dust_%s.png", intensity));
        this.rainSound = String.format("%s:%s", "dsurround", "rain");
        this.dustSound = String.format("%s:%s", "dsurround", "dust");
    }

    public static StormProperties getIntensity() {
        return intensity;
    }

    public static float getIntensityLevel() {
        return intensityLevel;
    }

    public static float getFogDensity() {
        return fogDensity;
    }

    public String getStormSound() {
        return this.rainSound;
    }

    public String getDustSound() {
        return this.dustSound;
    }

    public static float getCurrentVolume() {
        return (StormProperties.doVanilla() ? 0.66f : intensityLevel) * ModOptions.soundLevel;
    }

    public static ResourceLocation getCurrentStormSound() {
        return new ResourceLocation(StormProperties.intensity.rainSound);
    }

    public static ResourceLocation getCurrentDustSound() {
        return new ResourceLocation(StormProperties.intensity.dustSound);
    }

    public static boolean doVanilla() {
        return intensity == VANILLA;
    }

    public static void setIntensity(float level) {
        if (level == StormProperties.VANILLA.level) {
            intensity = VANILLA;
            intensityLevel = 0.0f;
            fogDensity = 0.0f;
            StormProperties.setTextures();
            return;
        }
        if (intensityLevel != (level = MathHelper.func_76131_a((float)level, (float)0.0f, (float)1.0f))) {
            intensityLevel = level;
            if (level > 0.0f) {
                level = (float)((double)level + 0.01);
                fogDensity = level * level * 0.13f;
            } else {
                fogDensity = 0.0f;
            }
            intensity = intensityLevel <= StormProperties.NONE.level ? NONE : (intensityLevel < StormProperties.CALM.level ? CALM : (intensityLevel < StormProperties.LIGHT.level ? LIGHT : (intensityLevel < StormProperties.NORMAL.level ? NORMAL : HEAVY)));
        }
    }

    public static void setTextures() {
        StormRenderer.locationRainPng = StormProperties.intensity.rainTexture;
        StormRenderer.locationSnowPng = StormProperties.intensity.snowTexture;
        StormRenderer.locationDustPng = StormProperties.intensity.dustTexture;
    }

    public static String diagnostic() {
        StringBuilder builder = new StringBuilder();
        builder.append("Storm: ").append(intensity.name());
        builder.append(" level:").append(intensityLevel);
        builder.append(" dust:").append(fogDensity);
        builder.append(" str:").append(EnvironStateHandler.EnvironState.getWorld().func_72867_j(1.0f));
        return builder.toString();
    }

    static {
        intensityLevel = 0.0f;
        intensity = VANILLA;
        fogDensity = 0.0f;
    }
}

