/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.storm;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.blockartistry.mod.DynSurround.client.IAtmosRenderer;
import org.blockartistry.mod.DynSurround.client.WeatherUtils;
import org.blockartistry.mod.DynSurround.client.storm.StormProperties;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.XorShiftRandom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StormRenderer
implements IAtmosRenderer {
    private static final XorShiftRandom random = new XorShiftRandom();
    public static ResourceLocation locationRainPng = new ResourceLocation("textures/environment/rain.png");
    public static ResourceLocation locationSnowPng = new ResourceLocation("textures/environment/snow.png");
    public static ResourceLocation locationDustPng = new ResourceLocation("dsurround", "textures/environment/dust.png");
    private static final float[] RAIN_X_COORDS = new float[1024];
    private static final float[] RAIN_Y_COORDS = new float[1024];

    private static int getPrecipitationHeight(World world, int x, int z) {
        if (world.field_73011_w.field_76574_g == -1) {
            return 0;
        }
        return world.func_72874_g(x, z);
    }

    @Override
    public void render(EntityRenderer renderer, float partialTicks) {
        StormProperties.setTextures();
        WorldClient world = renderer.field_78531_r.field_71441_e;
        IRenderHandler r = null;
        r = world.field_73011_w.getWeatherRenderer();
        if (r != null) {
            r.render(partialTicks, world, renderer.field_78531_r);
            return;
        }
        if (!DimensionRegistry.hasWeather((World)world)) {
            return;
        }
        float rainStrength = world.func_72867_j(partialTicks);
        if (rainStrength <= 0.0f) {
            return;
        }
        float alphaRatio = StormProperties.getIntensityLevel() > 0.0f ? world.field_73004_o / StormProperties.getIntensityLevel() : rainStrength;
        renderer.func_78463_b((double)partialTicks);
        EntityLivingBase entity = renderer.field_78531_r.field_71451_h;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        double spawnX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double spawnY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double spawnZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int locY = MathHelper.func_76128_c((double)spawnY);
        int b0 = renderer.field_78531_r.field_71474_y.field_74347_j ? 10 : 5;
        int b1 = -1;
        float f5 = (float)renderer.field_78529_t + partialTicks;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int locZ = playerZ - b0; locZ <= playerZ + b0; ++locZ) {
            for (int locX = playerX - b0; locX <= playerX + b0; ++locX) {
                float f10;
                int idx = (locZ - playerZ + 16) * 32 + locX - playerX + 16;
                float f6 = RAIN_X_COORDS[idx] * 0.5f;
                float f7 = RAIN_Y_COORDS[idx] * 0.5f;
                BiomeGenBase biome = world.func_72807_a(locX, locZ);
                boolean hasDust = WeatherUtils.biomeHasDust(biome);
                if (!hasDust && !BiomeRegistry.hasPrecipitation(biome)) continue;
                int k1 = StormRenderer.getPrecipitationHeight((World)world, locX, locZ);
                int l1 = playerY - b0;
                int i2 = playerY + b0;
                if (l1 < k1) {
                    l1 = k1;
                }
                if (i2 < k1) {
                    i2 = k1;
                }
                float f8 = 1.0f;
                int j2 = k1;
                if (k1 < locY) {
                    j2 = locY;
                }
                if (l1 == i2) continue;
                random.setSeed(locX * locX * 3121 + locX * 45238971 ^ locZ * locZ * 418711 + locZ * 13761);
                float heightTemp = world.func_72959_q().func_76939_a(biome.func_150564_a(locX, l1, locZ), k1);
                if (!hasDust && heightTemp >= 0.15f) {
                    if (b1 != 0) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 0;
                        renderer.field_78531_r.func_110434_K().func_110577_a(locationRainPng);
                        tessellator.func_78382_b();
                    }
                    f10 = ((float)(renderer.field_78529_t + locX * locX * 3121 + locX * 45238971 + locZ * locZ * 418711 + locZ * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                    double deltaX = (double)((float)locX + 0.5f) - entity.field_70165_t;
                    double deltaZ = (double)((float)locZ + 0.5f) - entity.field_70161_v;
                    float dist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) / (float)b0;
                    tessellator.func_78380_c(world.func_72802_i(locX, j2, locZ, 0));
                    tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - dist * dist) * 0.5f + 0.5f) * alphaRatio);
                    tessellator.func_78373_b(-spawnX * 1.0, -spawnY * 1.0, -spawnZ * 1.0);
                    tessellator.func_78374_a((double)((float)locX - f6) + 0.5, (double)l1, (double)((float)locZ - f7) + 0.5, (double)(0.0f * f8), (double)((float)l1 * f8 / 4.0f + f10 * f8));
                    tessellator.func_78374_a((double)((float)locX + f6) + 0.5, (double)l1, (double)((float)locZ + f7) + 0.5, (double)(1.0f * f8), (double)((float)l1 * f8 / 4.0f + f10 * f8));
                    tessellator.func_78374_a((double)((float)locX + f6) + 0.5, (double)i2, (double)((float)locZ + f7) + 0.5, (double)(1.0f * f8), (double)((float)i2 * f8 / 4.0f + f10 * f8));
                    tessellator.func_78374_a((double)((float)locX - f6) + 0.5, (double)i2, (double)((float)locZ - f7) + 0.5, (double)(0.0f * f8), (double)((float)i2 * f8 / 4.0f + f10 * f8));
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                    continue;
                }
                if (b1 != 1) {
                    if (b1 >= 0) {
                        tessellator.func_78381_a();
                    }
                    ResourceLocation texture = locationSnowPng;
                    if (hasDust && heightTemp >= 0.15f) {
                        texture = locationDustPng;
                    }
                    b1 = 1;
                    renderer.field_78531_r.func_110434_K().func_110577_a(texture);
                    tessellator.func_78382_b();
                }
                f10 = ((float)(renderer.field_78529_t & 0x1FF) + partialTicks) / 512.0f;
                float factor = hasDust ? 0.2f : 0.01f;
                float f16 = random.nextFloat() + f5 * factor * (float)random.nextGaussian();
                float f11 = random.nextFloat() + f5 * (float)random.nextGaussian() * 0.001f;
                double deltaX = (double)((float)locX + 0.5f) - entity.field_70165_t;
                double deltaZ = (double)((float)locZ + 0.5f) - entity.field_70161_v;
                float dist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) / (float)b0;
                tessellator.func_78380_c((world.func_72802_i(locX, j2, locZ, 0) * 3 + 0xF000F0) / 4);
                Color color = new Color(1.0f, 1.0f, 1.0f);
                if (world.field_73011_w.field_76574_g == -1) {
                    Color c = BiomeRegistry.getDustColor(biome);
                    if (color != null) {
                        color.mix(c);
                    }
                }
                tessellator.func_78369_a(color.red, color.green, color.blue, ((1.0f - dist * dist) * 0.3f + 0.5f) * alphaRatio);
                tessellator.func_78373_b(-spawnX * 1.0, -spawnY * 1.0, -spawnZ * 1.0);
                tessellator.func_78374_a((double)((float)locX - f6) + 0.5, (double)l1, (double)((float)locZ - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                tessellator.func_78374_a((double)((float)locX + f6) + 0.5, (double)l1, (double)((float)locZ + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                tessellator.func_78374_a((double)((float)locX + f6) + 0.5, (double)i2, (double)((float)locZ + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                tessellator.func_78374_a((double)((float)locX - f6) + 0.5, (double)i2, (double)((float)locZ - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                tessellator.func_78373_b(0.0, 0.0, 0.0);
            }
        }
        if (b1 >= 0) {
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        renderer.func_78483_a((double)partialTicks);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f2 = j - 16;
                float f3 = i - 16;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                StormRenderer.RAIN_X_COORDS[i << 5 | j] = -f3 / f4;
                StormRenderer.RAIN_Y_COORDS[i << 5 | j] = f2 / f4;
            }
        }
    }
}

