/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.server;

import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.data.DimensionEffectData;
import org.blockartistry.mod.DynSurround.data.DimensionEffectDataFile;
import org.blockartistry.mod.DynSurround.util.XorShiftRandom;

public class WorldHandler {
    private static final float STRENGTH_ADJUST = 0.01f;
    private static final Random random = new XorShiftRandom();

    private static int nextThunderInterval(boolean isThundering) {
        return random.nextInt(isThundering ? 12000 : 168000) + (isThundering ? 3600 : 12000);
    }

    private static int nextRainInterval(boolean isRaining) {
        return random.nextInt(isRaining ? 12000 : 168000) + 12000;
    }

    public static void updateWeatherBody(World world) {
        if (world.field_72995_K) {
            return;
        }
        int dimensionId = world.field_73011_w.field_76574_g;
        DimensionEffectData data = DimensionEffectDataFile.get(world);
        WorldInfo info = world.func_72912_H();
        int i = info.func_76071_n();
        if (i <= 0) {
            info.func_76090_f(WorldHandler.nextThunderInterval(info.func_76061_m()));
        } else {
            info.func_76090_f(--i);
            if (i <= 0) {
                info.func_76069_a(!info.func_76061_m());
            }
        }
        world.field_73018_p = world.field_73017_q;
        world.field_73017_q = world.field_73017_q + (info.func_76061_m() ? 0.01f : -0.01f);
        world.field_73017_q = MathHelper.func_76131_a((float)world.field_73017_q, (float)0.0f, (float)1.0f);
        int j = info.func_76083_p();
        if (j <= 0) {
            info.func_76080_g(WorldHandler.nextRainInterval(info.func_76059_o()));
        } else {
            info.func_76080_g(--j);
            if (j <= 0) {
                info.func_76084_b(!info.func_76059_o());
            }
        }
        if (info.func_76059_o() && data.getRainIntensity() == 0.0f) {
            data.randomizeRain();
            ModLog.debug(String.format("dim %d rain strength set to %f", dimensionId, Float.valueOf(data.getRainIntensity())), new Object[0]);
        }
        world.field_73003_n = world.field_73004_o;
        if (info.func_76059_o()) {
            if (world.field_73004_o > data.getRainIntensity()) {
                world.field_73004_o -= 0.01f;
                if (world.field_73004_o < 0.0f) {
                    world.field_73004_o = 0.0f;
                }
            } else if (world.field_73004_o < data.getRainIntensity()) {
                world.field_73004_o += 0.01f;
                if (world.field_73004_o > data.getRainIntensity()) {
                    world.field_73004_o = data.getRainIntensity();
                }
            }
        } else if (world.field_73004_o > 0.0f) {
            world.field_73004_o -= 0.01f;
            if (world.field_73004_o < 0.0f) {
                world.field_73004_o = 0.0f;
            }
        } else if (data.getRainIntensity() > 0.0f) {
            data.setRainIntensity(0.0f);
            ModLog.debug(String.format("dim %d rain has stopped", dimensionId), new Object[0]);
        }
    }
}

