/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.util;

import net.minecraft.world.World;

public final class DiurnalUtils {
    private DiurnalUtils() {
    }

    public static boolean isDaytime(World world) {
        if (world.field_73011_w.field_76574_g == 1) {
            return false;
        }
        float celestialAngle = DiurnalUtils.getCelestialAngle(world, 0.0f);
        return celestialAngle >= 0.785f || celestialAngle < 0.285f;
    }

    public static boolean isNighttime(World world) {
        if (world.field_73011_w.field_76574_g == 1) {
            return true;
        }
        float celestialAngle = DiurnalUtils.getCelestialAngle(world, 0.0f);
        return celestialAngle >= 0.285f && celestialAngle < 0.701f;
    }

    public static boolean isSunrise(World world) {
        if (world.field_73011_w.field_76574_g == 1) {
            return false;
        }
        float celestialAngle = DiurnalUtils.getCelestialAngle(world, 0.0f);
        return celestialAngle >= 0.701f && celestialAngle < 0.785f;
    }

    public static boolean isSunset(World world) {
        if (world.field_73011_w.field_76574_g == 1) {
            return false;
        }
        float celestialAngle = DiurnalUtils.getCelestialAngle(world, 0.0f);
        return (double)celestialAngle > 0.215 && celestialAngle <= 0.306f;
    }

    public static float getCelestialAngle(World world, float partialTickTime) {
        float angle = world.func_72826_c(partialTickTime);
        return angle >= 1.0f ? angle - 1.0f : angle;
    }

    public static float getMoonPhaseFactor(World world) {
        return world.func_130001_d();
    }

    public static long getClockTime(World world) {
        return world.func_72820_D() % 24000L;
    }
}

