/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.util;

import org.blockartistry.mod.DynSurround.util.XorShiftRandom;

public class MathStuff {
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final float RAD_FULL = (float)Math.PI * 2;
    private static final float RAD_TO_INDEX = 651.8986f;
    private static final float DEG_FULL = 360.0f;
    private static final float DEG_TO_INDEX = 11.377778f;
    private static final float COS_TO_SIN = 1.5707964f;
    private static final float[] SIN_TABLE;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float ATAN2_DIM_MINUS_1;
    private static final float[] ATAN2_TABLE;
    private static final float RAD_TO_DEG = 57.29578f;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float PI_F = (float)Math.PI;

    public static final float sin(float rad) {
        return SIN_TABLE[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float cos(float rad) {
        return SIN_TABLE[(int)((rad + 1.5707964f) * 651.8986f) & 0xFFF];
    }

    public static final float tan(float rad) {
        return MathStuff.sin(rad) / MathStuff.cos(rad);
    }

    public static final double sin(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)(tmp * 651.8986f) & 0xFFF];
    }

    public static final double cos(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)((tmp + 1.5707964f) * 651.8986f) & 0xFFF];
    }

    public static final double tan(double rad) {
        return MathStuff.tan((float)rad);
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = ATAN2_DIM_MINUS_1 / (x < y ? y : x);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (ATAN2_TABLE[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final double atan2(double y, double x) {
        float tmp1 = (float)y;
        float tmp2 = (float)x;
        return MathStuff.atan2(tmp1, tmp2);
    }

    public static final double random() {
        return XorShiftRandom.shared.nextDouble();
    }

    public static final float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final float toDegrees(float radians) {
        return radians * 57.29578f;
    }

    public static final float abs(float val) {
        return val < 0.0f ? -val : val;
    }

    static {
        int i;
        SIN_TABLE = new float[4096];
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        ATAN2_DIM_MINUS_1 = ATAN2_DIM - 1;
        ATAN2_TABLE = new float[16384];
        for (i = 0; i < 4096; ++i) {
            MathStuff.SIN_TABLE[i] = (float)Math.sin(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            MathStuff.SIN_TABLE[(int)((float)i * 11.377778f) & 0xFFF] = (float)Math.sin((double)i * Math.PI / 180.0);
        }
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathStuff.ATAN2_TABLE[j * MathStuff.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
    }
}

