/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.util;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class XorShiftRandom
extends Random {
    public static final XorShiftRandom shared = new XorShiftRandom();
    private static final long serialVersionUID = 1422228009367463911L;
    private static Field getSeed = null;
    private static final long GAMMA = -7046029254386353131L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private Double nextLocalGaussian = null;
    private long seed;
    private static final String BadBound = "bound must be positive";
    private static final String BadRange = "bound must be greater than origin";

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private static long initialSeed() {
        return XorShiftRandom.mix64(System.currentTimeMillis()) ^ XorShiftRandom.mix64(System.nanoTime());
    }

    public XorShiftRandom() {
        this(XorShiftRandom.initialSeed());
    }

    public XorShiftRandom(XorShiftRandom random) {
        this.seed = random.seed;
    }

    public XorShiftRandom(Random random) {
        if (random instanceof XorShiftRandom) {
            this.seed = ((XorShiftRandom)random).seed;
        } else {
            try {
                if (getSeed != null) {
                    this.seed = ((AtomicLong)getSeed.get(random)).get();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (this.seed == 0L) {
                    this.seed = XorShiftRandom.initialSeed();
                }
            }
        }
    }

    public XorShiftRandom(long seed) {
        this.seed = seed;
    }

    public XorShiftRandom(long seed1, long seed2) {
        this(XorShiftRandom.mix64(seed1) ^ XorShiftRandom.mix64(seed2));
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    private final long nextSeed() {
        return this.seed += -7046029254386353131L;
    }

    @Override
    protected int next(int bits) {
        return (int)(XorShiftRandom.mix64(this.nextSeed()) >>> 64 - bits);
    }

    private long internalNextLong0(long origin, long bound) {
        long r = XorShiftRandom.mix64(this.nextSeed());
        if (origin < bound) {
            long n = bound - origin;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = XorShiftRandom.mix64(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = XorShiftRandom.mix64(this.nextSeed());
                }
            }
        }
        return r;
    }

    private int internalNextInt0(int origin, int bound) {
        int r = XorShiftRandom.mix32(this.nextSeed());
        if (origin < bound) {
            int n = bound - origin;
            int m = n - 1;
            if ((n & m) == 0) {
                r = (r & m) + origin;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m - (r = u % n) < 0) {
                    u = XorShiftRandom.mix32(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = XorShiftRandom.mix32(this.nextSeed());
                }
            }
        }
        return r;
    }

    private double internalNextDouble0(double origin, double bound) {
        double r = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        if (origin < bound && (r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    @Override
    public int nextInt() {
        return XorShiftRandom.mix32(this.nextSeed());
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = XorShiftRandom.mix32(this.nextSeed());
        int m = bound - 1;
        if ((bound & m) == 0) {
            r &= m;
        } else {
            int u = r >>> 1;
            while (u + m - (r = u % bound) < 0) {
                u = XorShiftRandom.mix32(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextInt0(origin, bound);
    }

    @Override
    public long nextLong() {
        return XorShiftRandom.mix64(this.nextSeed());
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException(BadBound);
        }
        long r = XorShiftRandom.mix64(this.nextSeed());
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r &= m;
        } else {
            long u = r >>> 1;
            while (u + m - (r = u % bound) < 0L) {
                u = XorShiftRandom.mix64(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextLong0(origin, bound);
    }

    @Override
    public double nextDouble() {
        return (double)(XorShiftRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextDouble(double bound) {
        if (!(bound > 0.0)) {
            throw new IllegalArgumentException(BadBound);
        }
        double result = (double)(XorShiftRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f * bound;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (!(origin < bound)) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextDouble0(origin, bound);
    }

    @Override
    public boolean nextBoolean() {
        return XorShiftRandom.mix32(this.nextSeed()) < 0;
    }

    @Override
    public float nextFloat() {
        return (float)(XorShiftRandom.mix32(this.nextSeed()) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        Double d = this.nextLocalGaussian;
        if (d != null) {
            this.nextLocalGaussian = null;
            return d;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextLocalGaussian = new Double(v2 * multiplier);
        return v1 * multiplier;
    }

    static {
        try {
            getSeed = Random.class.getDeclaredField("seed");
            getSeed.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

