/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.LeafBreakingSchedule;
import fr.raksrinana.fallingtree.config.CommonConfig;
import fr.raksrinana.fallingtree.config.TreeConfiguration;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import io.netty.util.internal.ConcurrentSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="falling_tree")
public final class ForgeEventSubscriber {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = new ConcurrentSet();

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getWorld().field_72995_K && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && Objects.nonNull(event.getWorld())) {
            TreeHandler.getTree(event.getWorld(), event.getPos()).ifPresent(tree -> {
                if (TreeConfiguration.getMaxSize() >= tree.getLogCount()) {
                    if (TreeHandler.destroy(tree, event.getPlayer(), event.getPlayer().func_184586_b(EnumHand.MAIN_HAND))) {
                        event.setCanceled(true);
                    }
                } else {
                    event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), TreeConfiguration.getMaxSize()}));
                }
            });
        }
    }

    private static boolean isPlayerInRightState(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return false;
        }
        if (CommonConfig.reverseSneaking != player.func_70093_af()) {
            return false;
        }
        return TreeHandler.canPlayerBreakTree(player);
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (TreeConfiguration.isLavesBreaking() && !event.getWorld().field_72995_K) {
            BlockPos eventPos;
            WorldServer world = (WorldServer)event.getWorld();
            IBlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockAccess)world, eventPos = event.getPos())) {
                for (EnumFacing facing : event.getNotifiedSides()) {
                    IBlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.func_175667_e(neighborPos) || !((neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c() instanceof BlockLeaves)) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                WorldServer world = leafBreakingSchedule.getWorld();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    if (world.func_175667_e(leafBreakingSchedule.getBlockPos())) {
                        IBlockState state = world.func_180495_p(leafBreakingSchedule.getBlockPos());
                        Block block = state.func_177230_c();
                        if (block instanceof BlockLeaves) {
                            block.func_180645_a((World)world, leafBreakingSchedule.getBlockPos(), state, world.field_73012_v);
                            continue;
                        }
                        leavesBreak.remove();
                        continue;
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }
}

