/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="falling_tree")
public class CommonConfig {
    @Config.Name(value="reverse_sneaking")
    @Config.Comment(value={"When set to true, a tree will only be chopped down if the player is sneaking"})
    public static boolean reverseSneaking = false;

    @Nullable
    public static Block getBlock(String name) {
        try {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Item getItem(String name) {
        try {
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isReverseSneaking() {
        return reverseSneaking;
    }

    @Mod.EventBusSubscriber(modid="falling_tree")
    private static class Handler {
        private Handler() {
        }

        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("falling_tree")) {
                ConfigManager.sync((String)"falling_tree", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

