/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import fr.raksrinana.fallingtree.config.CommonConfig;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;

@Config(modid="falling_tree", category="tools")
public class ToolConfiguration {
    @Config.Name(value="whitelisted")
    @Config.Comment(value={"Additional list of tools (those marked with the axe tag will already be whitelisted) that can be used to chop down a tree"})
    public static String[] whitelisted = new String[0];
    @Config.Name(value="blacklisted")
    @Config.Comment(value={"List of tools that should not be considered as tools (this wins over the whitelist)"})
    public static String[] blacklisted = new String[0];
    @Config.Name(value="ignore_durability")
    @Config.Comment(value={"Ignore the durability loss of breaking all the logs. If set to true, no harm will be done to the tool"})
    public static boolean ignoreDurabilityLoss = false;
    @Config.Name(value="preserve")
    @Config.Comment(value={"When set to true, when a tree is broken and the tool is about to break we will just break one block and not the whole tree."})
    public static boolean preserve = false;

    public static Stream<Item> getBlacklisted() {
        return Arrays.stream(blacklisted).map(CommonConfig::getItem).filter(Objects::nonNull);
    }

    public static Stream<Item> getWhitelisted() {
        return Arrays.stream(whitelisted).map(CommonConfig::getItem).filter(Objects::nonNull);
    }

    public static boolean isIgnoreDurabilityLoss() {
        return ignoreDurabilityLoss;
    }

    public static boolean isPreserve() {
        return preserve;
    }

    @Mod.EventBusSubscriber(modid="falling_tree")
    private static class Handler {
        private Handler() {
        }

        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("falling_tree")) {
                ConfigManager.sync((String)"falling_tree", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

