/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import fr.raksrinana.fallingtree.config.ToolConfiguration;
import fr.raksrinana.fallingtree.config.TreeConfiguration;
import fr.raksrinana.fallingtree.tree.Tree;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TreeHandler {
    @Nonnull
    public static Optional<Tree> getTree(@Nonnull World world, @Nonnull BlockPos blockPos) {
        if (!TreeHandler.isTreeBlock(world, blockPos)) {
            return Optional.empty();
        }
        LinkedList<BlockPos> toAnalyzePos = new LinkedList<BlockPos>();
        HashSet<BlockPos> analyzedPos = new HashSet<BlockPos>();
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        Tree tree = new Tree(world, blockPos);
        toAnalyzePos.add(blockPos);
        while (!toAnalyzePos.isEmpty()) {
            BlockPos analyzingPos = (BlockPos)toAnalyzePos.remove();
            tree.addLog(analyzingPos);
            analyzedPos.add(analyzingPos);
            Collection<BlockPos> nearbyPos = TreeHandler.neighborLogs(world, logBlock, analyzingPos, analyzedPos);
            nearbyPos.removeAll(analyzedPos);
            toAnalyzePos.addAll(nearbyPos.stream().filter(pos -> !toAnalyzePos.contains(pos)).collect(Collectors.toList()));
        }
        return Optional.of(tree);
    }

    public static boolean isTreeBlock(@Nonnull World world, @Nonnull BlockPos blockPos) {
        boolean isWhitelistedBlock;
        Block block = world.func_180495_p(blockPos).func_177230_c();
        boolean bl = isWhitelistedBlock = block instanceof BlockLog || TreeConfiguration.getWhitelistedLogs().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = TreeConfiguration.getBlacklistedLogs().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    @Nonnull
    private static Collection<BlockPos> neighborLogs(@Nonnull World world, @Nonnull Block logBlock, @Nonnull BlockPos blockPos, @Nonnull Collection<BlockPos> analyzedPos) {
        LinkedList<BlockPos> neighborLogs = new LinkedList<BlockPos>();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    checkPos.func_181079_c(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z);
                    if (analyzedPos.contains(checkPos) || !TreeHandler.isSameLog(world, (BlockPos)checkPos, logBlock)) continue;
                    neighborLogs.add(checkPos.func_185334_h());
                }
            }
        }
        neighborLogs.addAll(analyzedPos);
        return neighborLogs;
    }

    private static boolean isSameLog(@Nonnull World world, @Nonnull BlockPos blockPos, @Nullable Block logBlock) {
        return world.func_180495_p(blockPos).func_177230_c().equals(logBlock);
    }

    public static boolean destroy(@Nonnull Tree tree, @Nonnull EntityPlayer player, @Nonnull ItemStack tool) {
        int radius;
        int toolUsesLeft;
        World world = tree.getWorld();
        int n = toolUsesLeft = !tool.func_77984_f() || ToolConfiguration.isIgnoreDurabilityLoss() ? Integer.MAX_VALUE : tool.func_77958_k() - tool.func_77952_i();
        if (ToolConfiguration.isPreserve()) {
            --toolUsesLeft;
        }
        if (toolUsesLeft < 1) {
            return false;
        }
        boolean isFullyBroken = ToolConfiguration.isIgnoreDurabilityLoss() || tool.func_77958_k() - tool.func_77952_i() >= tree.getLogCount();
        tree.getLogs().stream().limit(toolUsesLeft).forEachOrdered(logBlock -> {
            if (!ToolConfiguration.isIgnoreDurabilityLoss()) {
                tool.func_179548_a(world, world.func_180495_p(logBlock), logBlock, player);
            }
            world.func_175655_b(logBlock, true);
        });
        if (isFullyBroken && (radius = TreeConfiguration.getLavesBreakingForceRadius()) > 0) {
            tree.getLogs().stream().max(Comparator.comparingInt(Vec3i::func_177956_o)).ifPresent(topLog -> {
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.func_181079_c(topLog.func_177958_n() + dx, topLog.func_177956_o() + dy, topLog.func_177952_p() + dz);
                            IBlockState checkState = world.func_180495_p((BlockPos)checkPos);
                            Block checkBlock = checkState.func_177230_c();
                            if (!(checkBlock instanceof BlockLeaves)) continue;
                            checkBlock.func_176226_b(world, (BlockPos)checkPos, checkState, 0);
                            world.func_175655_b((BlockPos)checkPos, false);
                        }
                    }
                }
            });
        }
        return true;
    }

    public static boolean canPlayerBreakTree(@Nonnull EntityPlayer player) {
        boolean isWhitelistedTool;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        boolean bl = isWhitelistedTool = heldItem.func_77973_b() instanceof ItemAxe || ToolConfiguration.getWhitelisted().anyMatch(tool -> tool.equals(heldItem.func_77973_b()));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = ToolConfiguration.getBlacklisted().anyMatch(tool -> tool.equals(heldItem.func_77973_b()));
            return !isBlacklistedTool;
        }
        return false;
    }
}

