/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiTeleport;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GreenFlamesBase
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)9);

    public GreenFlamesBase() {
        super(Material.field_151581_o);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180634_a(World par1World, BlockPos pos, IBlockState state, Entity par4Entity) {
        if (par1World.field_72995_K) {
            if (par4Entity instanceof EntityPlayer) {
                this.doClientGuiTings(pos);
            }
        } else if (!(par4Entity instanceof EntityPlayer)) {
            boolean teleport = false;
            boolean landOutside = false;
            if (FloocraftBase.itemsTeleport && par4Entity instanceof EntityItem) {
                teleport = true;
                landOutside = true;
            } else if (FloocraftBase.villagersTeleport && par4Entity instanceof EntityVillager || FloocraftBase.miscMobsTeleport && par4Entity instanceof EntityLiving) {
                boolean bl = teleport = (double)par1World.field_73012_v.nextFloat() < 0.2;
            }
            if (teleport) {
                MessageFireplaceList mfl = FloocraftWorldData.forWorld(par1World).assembleNewFireplaceList(par1World);
                ArrayList<String> possibleLocations = new ArrayList<String>();
                Iterator<Boolean> enabledIter = mfl.enabledList.iterator();
                for (String nextName : mfl.placeList.keySet()) {
                    Boolean nextEnabled = enabledIter.next();
                    if (!nextEnabled.booleanValue()) continue;
                    possibleLocations.add(nextName);
                }
                String destName = (String)possibleLocations.get(par1World.field_73012_v.nextInt(possibleLocations.size()));
                int[] coords = mfl.placeList.get(destName);
                BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
                if (par1World.func_180495_p(dest).func_177230_c() == Blocks.field_150480_ab) {
                    par1World.func_175656_a(dest, FloocraftBase.greenFlamesTemp.func_176223_P());
                }
                if (landOutside) {
                    dest = dest.func_177972_a(this.isInFireplace(par1World, dest));
                    par4Entity.func_70012_b((double)dest.func_177958_n(), (double)coords[1], (double)dest.func_177952_p(), par4Entity.field_70177_z, par4Entity.field_70125_A);
                } else {
                    par4Entity.func_70012_b((double)coords[0], (double)coords[1], (double)coords[2], par4Entity.field_70177_z, par4Entity.field_70125_A);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientGuiTings(BlockPos pos) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(World par1World) {
        return 30;
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        if (this.isInFireplace(par1World, pos) != null) {
            par1World.func_175684_a(pos, (Block)this, this.func_149738_a(par1World));
        } else {
            par1World.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (this.isInFireplace(par1World, pos) == null || ((Integer)par1World.func_180495_p(pos).func_177229_b((IProperty)AGE)).equals(0)) {
            par1World.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        } else {
            par1World.func_175684_a(pos, (Block)this, this.func_149738_a(par1World) + par5Random.nextInt(10));
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean lolidkwhatthisis) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean hasTileEntity(IBlockState ibs) {
        return FloocraftBase.isAlbedoInstalled();
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2) throws NullPointerException;

    private int getTopBlockY(World w, BlockPos pos) {
        BlockPos newPos = pos.func_177967_a(EnumFacing.UP, 1);
        int y = newPos.func_177956_o();
        IBlockState bs = w.func_180495_p(newPos);
        while (bs.func_177230_c().isAir(bs, (IBlockAccess)w, newPos) && y < 256) {
            newPos = newPos.func_177967_a(EnumFacing.UP, 1);
            y = newPos.func_177956_o();
            bs = w.func_180495_p(newPos);
        }
        if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
            return y;
        }
        return 0;
    }

    private boolean isWallColumn(World w, BlockPos bottomPos, int topY) {
        boolean valid = true;
        BlockPos newBottomPos = bottomPos;
        while (valid && newBottomPos.func_177956_o() < topY) {
            IBlockState bs = w.func_180495_p(newBottomPos);
            if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
                newBottomPos = newBottomPos.func_177967_a(EnumFacing.UP, 1);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<EnumFacing> getWalls(World w, BlockPos bottomPos, int topY) {
        ArrayList<EnumFacing> walls = new ArrayList<EnumFacing>();
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.NORTH), topY)) {
            walls.add(EnumFacing.NORTH);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.WEST), topY)) {
            walls.add(EnumFacing.WEST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.EAST), topY)) {
            walls.add(EnumFacing.EAST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.SOUTH), topY)) {
            walls.add(EnumFacing.SOUTH);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, int x, int y, int z, EnumFacing backWall, EnumFacing oldSideWall, int top) {
        int oldX = x;
        int oldZ = z;
        EnumFacing sideWall = oldSideWall.func_176734_d();
        boolean stop = false;
        block4: while (!stop) {
            if (backWall == EnumFacing.NORTH || backWall == EnumFacing.SOUTH) {
                x = sideWall == EnumFacing.WEST ? --x : ++x;
            } else {
                z = sideWall == EnumFacing.NORTH ? ++z : --z;
            }
            BlockPos newBottomPos = new BlockPos(x, y, z);
            int newTop = this.getTopBlockY(w, newBottomPos);
            List<EnumFacing> walls = this.getWalls(w, newBottomPos, newTop);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top++ ? !this.isWallColumn(w, new BlockPos(oldX, top, oldZ), newTop) : newTop < top-- && !this.isWallColumn(w, new BlockPos(x, newTop, z), top)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block4;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block4;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public EnumFacing isInFireplace(World w, BlockPos pos) {
        int t;
        if (pos.func_177956_o() < 254 && (t = this.getTopBlockY(w, pos)) > 0) {
            List<EnumFacing> walls = this.getWalls(w, pos, t);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (walls.size()) {
                case 3: {
                    for (EnumFacing ef : EnumFacing.field_176754_o) {
                        if (walls.contains(ef)) continue;
                        return ef;
                    }
                    break;
                }
                case 2: {
                    if ((!walls.contains(EnumFacing.NORTH) || !walls.contains(EnumFacing.WEST) && !walls.contains(EnumFacing.EAST)) && (!walls.contains(EnumFacing.SOUTH) || !walls.contains(EnumFacing.WEST) && !walls.contains(EnumFacing.EAST))) break;
                    boolean zeroToOne = this.canLoopToCorner(w, x, y, z, walls.get(0), walls.get(1), t);
                    boolean oneToZero = this.canLoopToCorner(w, x, y, z, walls.get(1), walls.get(0), t);
                    if (zeroToOne && oneToZero) {
                        return EnumFacing.UP;
                    }
                    if (zeroToOne) {
                        return walls.get(0).func_176734_d();
                    }
                    if (!oneToZero) break;
                    return walls.get(1).func_176734_d();
                }
                case 1: {
                    switch (walls.get(0)) {
                        case NORTH: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.NORTH, EnumFacing.WEST, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.NORTH, EnumFacing.EAST, t)) {
                                return EnumFacing.SOUTH;
                            }
                        }
                        case WEST: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.WEST, EnumFacing.SOUTH, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.WEST, EnumFacing.NORTH, t)) {
                                return EnumFacing.EAST;
                            }
                        }
                        case EAST: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.EAST, EnumFacing.SOUTH, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.EAST, EnumFacing.NORTH, t)) {
                                return EnumFacing.WEST;
                            }
                        }
                        case SOUTH: {
                            if (!this.canLoopToCorner(w, x, y, z, EnumFacing.SOUTH, EnumFacing.WEST, t) || !this.canLoopToCorner(w, x, y, z, EnumFacing.SOUTH, EnumFacing.EAST, t)) break;
                            return EnumFacing.NORTH;
                        }
                    }
                    break;
                }
            }
        }
        return null;
    }
}

