/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft;

import com.fredtargaryen.floocraft.block.BlockFlooSign;
import com.fredtargaryen.floocraft.block.BlockFlooTorch;
import com.fredtargaryen.floocraft.block.BlockFloowerPot;
import com.fredtargaryen.floocraft.block.GreenFlamesBusy;
import com.fredtargaryen.floocraft.block.GreenFlamesIdle;
import com.fredtargaryen.floocraft.block.GreenFlamesTemp;
import com.fredtargaryen.floocraft.client.gui.GuiHandler;
import com.fredtargaryen.floocraft.entity.EntityPeeker;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import com.fredtargaryen.floocraft.item.ItemFlooSign;
import com.fredtargaryen.floocraft.network.PacketHandler;
import com.fredtargaryen.floocraft.proxy.CommonProxy;
import com.fredtargaryen.floocraft.tileentity.TileEntityFireplace;
import com.fredtargaryen.floocraft.tileentity.TileEntityFloowerPot;
import com.fredtargaryen.floocraft.tileentity.TileEntityMirageFire;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="floocraftft", name="Floocraft", version="1.9.5", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
@GameRegistry.ObjectHolder(value="floocraftft")
public class FloocraftBase {
    @Mod.Instance(value="floocraftft")
    public static FloocraftBase instance;
    private static boolean mirageInstalled;
    public static boolean villagersTeleport;
    public static boolean itemsTeleport;
    public static boolean miscMobsTeleport;
    @GameRegistry.ObjectHolder(value="flootorch")
    public static Block blockFlooTorch;
    @GameRegistry.ObjectHolder(value="greenflamesbusy")
    public static Block greenFlamesBusy;
    @GameRegistry.ObjectHolder(value="greenflamesidle")
    public static Block greenFlamesIdle;
    @GameRegistry.ObjectHolder(value="greenflamestemp")
    public static Block greenFlamesTemp;
    @GameRegistry.ObjectHolder(value="blockfloosign")
    public static Block blockFlooSign;
    @GameRegistry.ObjectHolder(value="floowerpot")
    public static Block floowerPot;
    @GameRegistry.ObjectHolder(value="itemfloosign")
    public static Item itemFlooSign;
    @GameRegistry.ObjectHolder(value="flootorch")
    public static Item iFlooTorch;
    @GameRegistry.ObjectHolder(value="floowerpot")
    public static Item iFloowerPot;
    @GameRegistry.ObjectHolder(value="floopowder_one")
    public static Item floopowder1t;
    @GameRegistry.ObjectHolder(value="floopowder_two")
    public static Item floopowder2t;
    @GameRegistry.ObjectHolder(value="floopowder_four")
    public static Item floopowder4t;
    @GameRegistry.ObjectHolder(value="floopowder_eight")
    public static Item floopowder8t;
    @GameRegistry.ObjectHolder(value="floopowder_infinite")
    public static Item floopowderc;
    @GameRegistry.ObjectHolder(value="greened")
    public static SoundEvent greened;
    @GameRegistry.ObjectHolder(value="tp")
    public static SoundEvent tp;
    @GameRegistry.ObjectHolder(value="flick")
    public static SoundEvent flick;
    @SidedProxy(clientSide="com.fredtargaryen.floocraft.proxy.ClientProxy", serverSide="com.fredtargaryen.floocraft.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        villagersTeleport = config.getBoolean("Villagers Teleport", "Teleportation", false, "If true, villagers who wander into Floo fires MAY teleport to a random fireplace. Never consumes Floo Powder");
        itemsTeleport = config.getBoolean("Items Teleport", "Teleportation", false, "If true, dropped items that touch Floo fires WILL teleport to a random fireplace. Never consumes Floo Powder");
        miscMobsTeleport = config.getBoolean("Misc. Mobs Teleport", "Teleportation", false, "As with villagers, but for Sheep, Cows, Spiders, Silverfish, Zombies etc. Never consumes Floo Powder");
        config.save();
        blockFlooTorch = ((Block)new BlockFlooTorch().func_149663_c("flootorch").setRegistryName("flootorch")).func_149715_a(1.0f).func_149647_a(CreativeTabs.field_78031_c);
        greenFlamesBusy = ((Block)new GreenFlamesBusy().func_149663_c("greenflamesbusy").setRegistryName("greenflamesbusy")).func_149715_a(1.0f);
        greenFlamesIdle = ((Block)new GreenFlamesIdle().func_149663_c("greenflamesidle").setRegistryName("greenflamesidle")).func_149715_a(0.875f);
        greenFlamesTemp = ((Block)new GreenFlamesTemp().func_149663_c("greenflamesbusy").setRegistryName("greenflamestemp")).func_149715_a(1.0f);
        blockFlooSign = (Block)new BlockFlooSign().setRegistryName("blockfloosign");
        floowerPot = ((Block)new BlockFloowerPot().func_149663_c("floowerpot").setRegistryName("floowerpot")).func_149647_a(CreativeTabs.field_78026_f);
        iFlooTorch = (Item)new ItemBlock(blockFlooTorch).func_77655_b("flootorch").setRegistryName("flootorch");
        iFloowerPot = (Item)new ItemBlock(floowerPot).func_77655_b("floowerpot").setRegistryName("floowerpot");
        floopowder1t = ((Item)new ItemFlooPowder(1).func_77625_d(64).func_77655_b("floopowder").setRegistryName("floopowder_one")).func_77637_a(CreativeTabs.field_78026_f);
        floopowder2t = ((Item)new ItemFlooPowder(2).func_77625_d(64).func_77655_b("floopowder").setRegistryName("floopowder_two")).func_77637_a(CreativeTabs.field_78026_f);
        floopowder4t = ((Item)new ItemFlooPowder(4).func_77625_d(64).func_77655_b("floopowder").setRegistryName("floopowder_four")).func_77637_a(CreativeTabs.field_78026_f);
        floopowder8t = ((Item)new ItemFlooPowder(8).func_77625_d(64).func_77655_b("floopowder").setRegistryName("floopowder_eight")).func_77637_a(CreativeTabs.field_78026_f);
        floopowderc = ((Item)new ItemFlooPowder(9).func_77625_d(64).func_77655_b("floopowder").setRegistryName("floopowder_infinite")).func_77637_a(CreativeTabs.field_78026_f);
        itemFlooSign = ((Item)new ItemFlooSign().func_77625_d(16).func_77655_b("itemfloosign").setRegistryName("itemfloosign")).func_77637_a(CreativeTabs.field_78031_c);
        greened = (SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "greened")).setRegistryName("greened");
        tp = (SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "tp")).setRegistryName("tp");
        flick = (SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "flick")).setRegistryName("flick");
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)greened);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)tp);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)flick);
        GameRegistry.registerTileEntity(TileEntityFireplace.class, (ResourceLocation)new ResourceLocation("floocraftft", "fireplace"));
        GameRegistry.registerTileEntity(TileEntityFloowerPot.class, (ResourceLocation)new ResourceLocation("floocraftft", "pot"));
        GameRegistry.registerTileEntity(TileEntityMirageFire.class, (ResourceLocation)new ResourceLocation("floocraftft", "greenlight"));
        proxy.registerTextureStitcher();
        proxy.registerRenderers();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs modFixs = fixer.init("ftfloocraft", 0);
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, new IFixableData(){

            public int func_188216_a() {
                return 0;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                return compound;
            }
        });
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, new IDataWalker(){

            public NBTTagCompound func_188266_a(IDataFixer fixer, NBTTagCompound compound, int versionIn) {
                String id = compound.func_74779_i("id");
                if (id.equals("ftfloocraft:fireplacete")) {
                    compound.func_74778_a("id", "floocraftft:fireplace");
                } else if (id.equals("ftfloocraft:greenlightte")) {
                    compound.func_74778_a("id", "floocraftft:greenlight");
                } else if (id.equals("ftfloocraft:potte")) {
                    compound.func_74778_a("id", "floocraftft:pot");
                }
                return compound;
            }
        });
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ResourceLocation peekerLocation = new ResourceLocation("floocraftft", "peeker");
        EntityRegistry.registerModEntity((ResourceLocation)peekerLocation, EntityPeeker.class, (String)"peeker", (int)0, (Object)instance, (int)32, (int)1, (boolean)false);
        proxy.registerTickHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        mirageInstalled = Loader.isModLoaded((String)"mirage");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{blockFlooSign, blockFlooTorch, greenFlamesBusy, greenFlamesIdle, greenFlamesTemp, floowerPot});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{iFloowerPot, iFlooTorch, floopowder1t, floopowder2t, floopowder4t, floopowder8t, floopowderc, itemFlooSign});
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    public static boolean isMirageInstalled() {
        return mirageInstalled;
    }

    public static Entity getEntityWithUUID(World world, UUID uuid) {
        if (world == null || uuid == null) {
            return null;
        }
        List entities = world.field_72996_f;
        for (Entity nextEntity : entities) {
            if (!nextEntity.func_110124_au().equals(uuid)) continue;
            return nextEntity;
        }
        return null;
    }

    @SubscribeEvent
    public static void handleMissingMappings(RegistryEvent.MissingMappings evt) {
        block57: {
            String fullName;
            block59: {
                block58: {
                    block56: {
                        fullName = evt.getName().toString();
                        if (!fullName.equals("minecraft:blocks")) break block56;
                        for (Object mapping : evt.getAllMappings()) {
                            RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                            if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                            switch (trueMapping.key.func_110623_a()) {
                                case "flootorch": {
                                    trueMapping.remap((IForgeRegistryEntry)blockFlooTorch);
                                    break;
                                }
                                case "greenflamesbusy": {
                                    trueMapping.remap((IForgeRegistryEntry)greenFlamesBusy);
                                    break;
                                }
                                case "greenflamesidle": {
                                    trueMapping.remap((IForgeRegistryEntry)greenFlamesIdle);
                                    break;
                                }
                                case "greenflamestemp": {
                                    trueMapping.remap((IForgeRegistryEntry)greenFlamesTemp);
                                    break;
                                }
                                case "blockfloosign": {
                                    trueMapping.remap((IForgeRegistryEntry)blockFlooSign);
                                    break;
                                }
                                case "floowerpot": {
                                    trueMapping.remap((IForgeRegistryEntry)floowerPot);
                                    break;
                                }
                            }
                        }
                        break block57;
                    }
                    if (!fullName.equals("minecraft:items")) break block58;
                    for (Object mapping : evt.getAllMappings()) {
                        RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                        if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                        switch (trueMapping.key.func_110623_a()) {
                            case "flootorch": {
                                trueMapping.remap((IForgeRegistryEntry)iFlooTorch);
                                break;
                            }
                            case "floowerpot": {
                                trueMapping.remap((IForgeRegistryEntry)iFloowerPot);
                                break;
                            }
                            case "floopowder_one": {
                                trueMapping.remap((IForgeRegistryEntry)floopowder1t);
                                break;
                            }
                            case "floopowder_two": {
                                trueMapping.remap((IForgeRegistryEntry)floopowder2t);
                                break;
                            }
                            case "floopowder_four": {
                                trueMapping.remap((IForgeRegistryEntry)floopowder4t);
                                break;
                            }
                            case "floopowder_eight": {
                                trueMapping.remap((IForgeRegistryEntry)floopowder8t);
                                break;
                            }
                            case "floopowder_infinite": {
                                trueMapping.remap((IForgeRegistryEntry)floopowderc);
                                break;
                            }
                            case "itemfloosign": {
                                trueMapping.remap((IForgeRegistryEntry)itemFlooSign);
                                break;
                            }
                        }
                    }
                    break block57;
                }
                if (!fullName.equals("minecraft:entities")) break block59;
                for (Object mapping : evt.getAllMappings()) {
                    RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                    if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                    switch (trueMapping.key.func_110623_a()) {
                        case "peeker": {
                            trueMapping.remap((IForgeRegistryEntry)EntityRegistry.getEntry(EntityPeeker.class));
                            break;
                        }
                    }
                }
                break block57;
            }
            if (!fullName.equals("minecraft:soundevents")) break block57;
            for (Object mapping : evt.getAllMappings()) {
                RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                switch (trueMapping.key.func_110623_a()) {
                    case "tp": {
                        trueMapping.remap((IForgeRegistryEntry)tp);
                        break;
                    }
                    case "flick": {
                        trueMapping.remap((IForgeRegistryEntry)flick);
                        break;
                    }
                    case "greened": {
                        trueMapping.remap((IForgeRegistryEntry)greened);
                        break;
                    }
                }
            }
        }
    }
}

