/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiPeek;
import com.fredtargaryen.floocraft.network.PacketHandler;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceListRequest;
import com.fredtargaryen.floocraft.network.messages.MessagePeekRequest;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import com.fredtargaryen.floocraft.network.messages.MessageTeleportEntity;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTeleport
extends GuiScreen {
    private static final String screenTitle = "===Choose a destination===";
    private String status;
    private GuiButton peekBtn;
    private GuiButton goBtn;
    private GuiButton cancelBtn;
    private boolean[] enabledList;
    private boolean receivedLists;
    private PlaceList scrollWindow;
    private final int initX;
    private final int initY;
    private final int initZ;
    private Object[] placeList;

    public GuiTeleport(int x, int y, int z) {
        this.initX = x;
        this.initY = y;
        this.initZ = z;
        this.refresh();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        GuiButton refreshButton = new GuiButton(-2, this.field_146294_l - 100, 0, 98, 20, "Refresh");
        refreshButton.field_146124_l = false;
        this.peekBtn = new GuiButton(-4, this.field_146294_l / 2 - 151, this.field_146295_m - 40, 98, 20, "Peek...");
        this.field_146292_n.add(this.peekBtn);
        this.peekBtn.field_146124_l = false;
        this.goBtn = new GuiButton(-3, this.field_146294_l / 2 - 49, this.field_146295_m - 40, 98, 20, "Go!");
        this.field_146292_n.add(this.goBtn);
        this.goBtn.field_146124_l = false;
        this.cancelBtn = new GuiButton(-1, this.field_146294_l / 2 + 53, this.field_146295_m - 40, 98, 20, "Cancel");
        this.field_146292_n.add(this.cancelBtn);
        if (this.receivedLists) {
            refreshButton.field_146124_l = true;
            this.scrollWindow = new PlaceList();
        }
        this.field_146292_n.add(refreshButton);
    }

    public void func_146281_b() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        Keyboard.enableRepeatEvents((boolean)false);
        proxy.overrideTicker.start();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.status = !this.receivedLists ? "Loading..." : (this.placeList.length == 0 ? "No places found" : "");
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int id = this.scrollWindow.getSelectedElement();
            if (par1GuiButton.field_146127_k == -1) {
                ((ClientProxy)FloocraftBase.proxy).overrideTicker.start();
                this.field_146297_k.func_147108_a(null);
            } else if (par1GuiButton.field_146127_k == -2) {
                this.refresh();
            } else if (par1GuiButton.field_146127_k == -3) {
                int initX = this.initX;
                int initY = this.initY;
                int initZ = this.initZ;
                String dest = (String)this.placeList[id];
                try {
                    MessageTeleportEntity m = new MessageTeleportEntity();
                    m.initX = initX;
                    m.initY = initY;
                    m.initZ = initZ;
                    m.dest = dest;
                    PacketHandler.INSTANCE.sendToServer((IMessage)m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.func_146284_a(this.cancelBtn);
            } else if (par1GuiButton.field_146127_k == -4) {
                String dest = (String)this.placeList[id];
                try {
                    MessagePeekRequest m = new MessagePeekRequest();
                    m.initX = this.initX;
                    m.initY = this.initY;
                    m.initZ = this.initZ;
                    m.dest = dest;
                    PacketHandler.INSTANCE.sendToServer((IMessage)m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.func_146284_a(this.cancelBtn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mousex, int mousey, float partialticks) {
        this.func_73732_a(this.field_146289_q, this.status, this.field_146294_l / 2, this.field_146295_m / 4 + 48, 0xC8C8C8);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_146294_l / 2), (float)0.0f, (float)50.0f);
        float f1 = 93.75f;
        GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (this.scrollWindow != null) {
            this.scrollWindow.func_148128_a(mousex, mousey, partialticks);
        }
        this.func_73732_a(this.field_146289_q, screenTitle, this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mousex, mousey, partialticks);
    }

    private void refresh() {
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.receivedLists = false;
        this.func_73866_w_();
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageFireplaceListRequest());
    }

    public void onFireplaceList(MessageFireplaceList m) {
        try {
            this.placeList = m.places;
            this.enabledList = m.enabledList;
            this.receivedLists = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.func_73866_w_();
    }

    public void onStartPeek(MessageStartPeek msp) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPeek((String)this.placeList[this.scrollWindow.getSelectedElement()], msp.peekerUUID));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146274_d() {
        try {
            if (this.scrollWindow != null) {
                this.scrollWindow.func_178039_p();
            }
            super.func_146274_d();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    class PlaceList
    extends GuiSlot {
        public PlaceList() {
            super(GuiTeleport.this.field_146297_k, GuiTeleport.this.field_146294_l, GuiTeleport.this.field_146295_m, 32, GuiTeleport.this.field_146295_m - 64, 18);
            this.func_193651_b(true);
        }

        public int func_148139_c() {
            return 380;
        }

        protected int func_148127_b() {
            return GuiTeleport.this.placeList.length;
        }

        protected void func_148144_a(int id, boolean isDoubleClick, int mousex, int mousey) {
            boolean enabled;
            ((GuiTeleport)GuiTeleport.this).goBtn.field_146124_l = enabled = GuiTeleport.this.enabledList[id];
            ((GuiTeleport)GuiTeleport.this).peekBtn.field_146124_l = enabled;
        }

        protected boolean func_148131_a(int id) {
            return id == this.field_148168_r;
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int id, int p_148126_2_, int p_148126_3_, int p_148126_4_, int p_148126_6_, int p_148126_7_, float idk) {
            GuiTeleport.this.func_73732_a(GuiTeleport.this.field_146289_q, (String)GuiTeleport.this.placeList[id], this.field_148155_a / 2, p_148126_3_ + 1, GuiTeleport.this.enabledList[id] ? 65280 : 0xFF0000);
        }

        public void func_148128_a(int i, int j, float f) {
            super.func_148128_a(i, j, f);
            this.flooverlayBackground(0, this.field_148153_b);
            this.flooverlayBackground(this.field_148154_c, this.field_148158_l);
        }

        private void flooverlayBackground(int p_148136_1_, int p_148136_2_) {
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            GuiTeleport.this.field_146297_k.func_110434_K().func_110577_a(DataReference.TP_BACKGROUND);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b((double)this.field_148152_e, (double)p_148136_2_, 0.0).func_187315_a(0.0, (double)((float)p_148136_2_ / f)).func_181675_d();
            wr.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_2_, 0.0).func_187315_a((double)((float)this.field_148155_a / f), (double)((float)p_148136_2_ / f)).func_181675_d();
            wr.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_1_, 0.0).func_187315_a((double)((float)this.field_148155_a / f), (double)((float)p_148136_1_ / f)).func_181675_d();
            wr.func_181662_b((double)this.field_148152_e, (double)p_148136_1_, 0.0).func_187315_a(0.0, (double)((float)p_148136_1_ / f)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }

        protected void drawContainerBackground(Tessellator tessellator) {
        }

        public int getSelectedElement() {
            return this.field_148168_r;
        }
    }
}

