/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLLog;

public class FloocraftWorldData
extends WorldSavedData {
    public final ConcurrentHashMap<String, int[]> placeList = new ConcurrentHashMap();

    public FloocraftWorldData(String key) {
        super(key);
    }

    public static FloocraftWorldData forWorld(World world) {
        MapStorage storage = world.getPerWorldStorage();
        FloocraftWorldData data = (FloocraftWorldData)storage.func_75742_a(FloocraftWorldData.class, "floocraftft");
        if (data == null) {
            FMLLog.warning((String)"[FLOOCRAFT-SERVER] No fireplace data was found for this world. Creating new fireplace data.", (Object[])new Object[0]);
            data = new FloocraftWorldData("floocraftft");
            storage.func_75745_a("floocraftft", (WorldSavedData)data);
        }
        return data;
    }

    public void addLocation(String name, BlockPos pos) {
        this.placeList.put(name, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        FMLLog.info((String)("[FLOOCRAFT-SERVER] Added fireplace at " + pos.toString() + ". Name: " + name), (Object[])new Object[0]);
        this.func_76185_a();
    }

    public void removeLocation(int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        boolean removedPlace = false;
        Iterator i = ((ConcurrentHashMap.KeySetView)this.placeList.keySet()).iterator();
        while (i.hasNext() && !removedPlace) {
            String nextPlaceName = (String)i.next();
            if (!Arrays.equals(this.placeList.get(nextPlaceName), coords)) continue;
            FMLLog.info((String)("[FLOOCRAFT-SERVER] Removed fireplace at (" + x + ", " + y + ", " + z + "). Name: " + nextPlaceName), (Object[])new Object[0]);
            this.placeList.remove(nextPlaceName);
            removedPlace = true;
        }
        if (!removedPlace) {
            FMLLog.warning((String)("[FLOOCRAFT-SERVER] Failed to remove fireplace at (" + x + ", " + y + ", " + z + ")."), (Object[])new Object[0]);
            FMLLog.warning((String)"[FLOOCRAFT-SERVER] Data can be manually removed with an NBT editor.", (Object[])new Object[0]);
        }
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("floocraftft", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
            int[] coords = new int[]{nbt1.func_74762_e("X"), nbt1.func_74762_e("Y"), nbt1.func_74762_e("Z")};
            this.placeList.put(nbt1.func_74779_i("NAME"), coords);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (String nextName : this.placeList.keySet()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("NAME", nextName);
            int[] coords = this.placeList.get(nextName);
            nbt1.func_74768_a("X", coords[0]);
            nbt1.func_74768_a("Y", coords[1]);
            nbt1.func_74768_a("Z", coords[2]);
            nbttaglist.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("floocraftft", (NBTBase)nbttaglist);
        return nbt;
    }

    public MessageFireplaceList assembleNewFireplaceList(World w) {
        MessageFireplaceList m = new MessageFireplaceList();
        m.places = ((ConcurrentHashMap.CollectionView)((Object)this.placeList.keySet())).toArray();
        boolean[] l = new boolean[m.places.length];
        int keyCount = 0;
        for (String nextName : this.placeList.keySet()) {
            boolean ok;
            int[] coords = this.placeList.get(nextName);
            BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
            Block b = w.func_180495_p(dest).func_177230_c();
            if (b instanceof BlockFire) {
                ok = ((GreenFlamesBase)FloocraftBase.greenFlamesTemp).isInFireplace(w, dest) != null;
                w.func_175656_a(dest, Blocks.field_150480_ab.func_176223_P());
            } else {
                ok = b instanceof GreenFlamesBase;
            }
            l[keyCount] = ok;
            ++keyCount;
        }
        m.enabledList = l;
        return m;
    }
}

