/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.particle.ParticleGreenFlame;
import com.fredtargaryen.floocraft.network.PacketHandler;
import com.fredtargaryen.floocraft.network.messages.MessageFlooTorchTeleport;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockFlooTorch
extends BlockTorch {
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)6.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)12.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)3.0, (double)6.0, (double)4.0, (double)13.0, (double)10.0);
    public static final DirectionProperty FACING_EXCEPT_DOWN = DirectionProperty.func_177712_a((String)"facing", p_208125_0_ -> p_208125_0_ != EnumFacing.DOWN);

    public BlockFlooTorch() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_200951_a(14).func_200947_a(SoundType.field_185848_a));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING_EXCEPT_DOWN)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return field_196526_y;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING_EXCEPT_DOWN});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING_EXCEPT_DOWN)) {
            case NORTH: {
                d1 += 0.145;
                d2 += 0.25;
                break;
            }
            case SOUTH: {
                d1 += 0.145;
                d2 -= 0.25;
                break;
            }
            case WEST: {
                d1 += 0.145;
                d0 += 0.25;
                break;
            }
            case EAST: {
                d1 += 0.145;
                d0 -= 0.25;
            }
        }
        worldIn.func_195594_a((IParticleData)Particles.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGreenFlame(worldIn, d0, d1, d2));
    }

    public boolean func_149703_v() {
        return true;
    }

    public int func_196251_a(IBlockState state, int fortune, World worldIn, BlockPos pos, Random random) {
        return 1;
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K && entity instanceof EntityPlayer) {
            MessageFlooTorchTeleport mftt = new MessageFlooTorchTeleport();
            mftt.torchX = pos.func_177958_n();
            mftt.torchY = pos.func_177956_o();
            mftt.torchZ = pos.func_177952_p();
            PacketHandler.INSTANCE.sendToServer((Object)mftt);
        }
    }

    public Item func_199767_j() {
        return FloocraftBase.ITEM_FLOO_TORCH;
    }
}

