/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import com.fredtargaryen.floocraft.tileentity.TileEntityFloowerPot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockFloowerPot
extends Block {
    protected static final VoxelShape POTBOX = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public BlockFloowerPot() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return POTBOX;
    }

    public boolean hasTileEntity(IBlockState ibs) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityFloowerPot();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)((IInteractionObject)tileEntity), buf -> {
            BlockPos blockPos = tileEntity.func_174877_v();
            buf.writeInt(blockPos.func_177958_n());
            buf.writeInt(blockPos.func_177956_o());
            buf.writeInt(blockPos.func_177952_p());
        });
        return true;
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        this.dropItems(worldIn, pos);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item.func_190926_b() || item.func_190916_E() <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack((IItemProvider)item.func_77973_b(), item.func_190916_E(), item.func_77978_p()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
        }
    }

    public int func_149738_a(IWorldReaderBase par1World) {
        return 50;
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_196267_b(state, world, pos, rand);
        if (!world.field_72995_K) {
            TileEntityFloowerPot pot = (TileEntityFloowerPot)world.func_175625_s(pos);
            ItemStack stack = pot.func_70301_a(0);
            if (stack != null && stack.func_190916_E() > 0) {
                int par2 = pos.func_177958_n();
                int par3 = pos.func_177956_o();
                int par4 = pos.func_177952_p();
                for (int x = par2 - 5; x < par2 + 6; ++x) {
                    for (int y = par3 - 5; y < par3 + 6; ++y) {
                        for (int z = par4 - 5; z < par4 + 6; ++z) {
                            BlockPos currentPos;
                            Block currentBlock;
                            if (stack == null || stack.func_190916_E() <= 0 || (currentBlock = world.func_180495_p(currentPos = new BlockPos(x, y, z)).func_177230_c()) != Blocks.field_150480_ab) continue;
                            if (((GreenFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP).isInFireplace(world, currentPos) != null) {
                                Item i = stack.func_77973_b();
                                world.func_180501_a(currentPos, (IBlockState)FloocraftBase.GREEN_FLAMES_IDLE.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(((ItemFlooPowder)i).getConcentration())), 3);
                                world.func_184133_a(null, currentPos, FloocraftBase.GREENED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                stack = stack.func_190916_E() == 1 ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - 1);
                                continue;
                            }
                            world.func_175656_a(currentPos, Blocks.field_150480_ab.func_176223_P());
                        }
                    }
                }
            }
            pot.func_70299_a(0, stack);
            world.func_184138_a(pos, state, state, 3);
            world.func_205220_G_().func_205362_a(pos, (Object)state.func_177230_c(), this.func_149738_a((IWorldReaderBase)world) + rand.nextInt(100), TickPriority.EXTREMELY_LOW);
        }
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        worldIn.func_205220_G_().func_205362_a(pos, (Object)state.func_177230_c(), this.func_149738_a((IWorldReaderBase)worldIn), TickPriority.EXTREMELY_LOW);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return super.func_196260_a(state, worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockReader)worldIn, pos, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos someOtherPos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockReader)worldIn, pos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            this.func_196243_a(state, worldIn, pos, Blocks.field_150350_a.func_176223_P(), false);
        }
    }
}

