/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiTeleport;
import com.fredtargaryen.floocraft.config.GeneralConfig;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GreenFlamesBase
extends Block {
    private static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final VoxelShape TALLBOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    GreenFlamesBase(int lightLevel) {
        super(Block.Properties.func_200945_a((Material)Material.field_151581_o).func_200951_a(lightLevel));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208171_X});
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return TALLBOX;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            if (entityIn == Minecraft.func_71410_x().field_71439_g) {
                this.doClientGuiTings(pos);
            }
        } else if (!(entityIn instanceof EntityPlayer)) {
            boolean teleport = false;
            boolean landOutside = false;
            if (((Boolean)GeneralConfig.ITEMS_TELEPORT.get()).booleanValue() && entityIn instanceof EntityItem) {
                teleport = true;
                landOutside = true;
            } else if (((Boolean)GeneralConfig.VILLAGERS_TELEPORT.get()).booleanValue() && entityIn instanceof EntityVillager || ((Boolean)GeneralConfig.MISC_MOBS_TELEPORT.get()).booleanValue() && entityIn instanceof EntityLiving) {
                boolean bl = teleport = (double)worldIn.field_73012_v.nextFloat() < 0.2;
            }
            if (teleport) {
                FloocraftWorldData fwd = FloocraftWorldData.forWorld(worldIn);
                MessageFireplaceList mfl = fwd.assembleNewFireplaceList(worldIn);
                ArrayList<String> possibleLocations = new ArrayList<String>();
                for (int i = 0; i < mfl.places.length; ++i) {
                    if (!mfl.enabledList[i]) continue;
                    possibleLocations.add((String)mfl.places[i]);
                }
                int destNo = worldIn.field_73012_v.nextInt(possibleLocations.size());
                String destName = (String)possibleLocations.get(destNo);
                int[] coords = fwd.placeList.get(destName);
                BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
                if (worldIn.func_180495_p(dest).func_177230_c() == Blocks.field_150480_ab) {
                    worldIn.func_175656_a(dest, FloocraftBase.GREEN_FLAMES_TEMP.func_176223_P());
                }
                if (landOutside) {
                    dest = dest.func_177972_a(this.isInFireplace(worldIn, dest));
                    entityIn.func_70012_b((double)dest.func_177958_n(), (double)coords[1], (double)dest.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
                } else {
                    entityIn.func_70012_b((double)coords[0], (double)coords[1], (double)coords[2], entityIn.field_70177_z, entityIn.field_70125_A);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientGuiTings(BlockPos pos) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(IWorldReaderBase par1World) {
        return 30;
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        if (this.isInFireplace(worldIn, pos) != null) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReaderBase)worldIn));
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isInFireplace(world, pos) == null || ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperties.field_208171_X)).equals(0)) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        } else {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReaderBase)world) + rand.nextInt(10));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)Particles.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    private int getTopBlockY(World w, BlockPos pos) {
        BlockPos newPos = pos.func_177967_a(EnumFacing.UP, 1);
        int y = newPos.func_177956_o();
        IBlockState bs = w.func_180495_p(newPos);
        while (bs.func_177230_c().isAir(bs, (IBlockReader)w, newPos) && y < 256) {
            newPos = newPos.func_177967_a(EnumFacing.UP, 1);
            y = newPos.func_177956_o();
            bs = w.func_180495_p(newPos);
        }
        if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
            return y;
        }
        return 0;
    }

    private boolean isWallColumn(World w, BlockPos bottomPos, int topY) {
        boolean valid = true;
        BlockPos newBottomPos = bottomPos;
        while (valid && newBottomPos.func_177956_o() < topY) {
            IBlockState bs = w.func_180495_p(newBottomPos);
            if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
                newBottomPos = newBottomPos.func_177967_a(EnumFacing.UP, 1);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<EnumFacing> getWalls(World w, BlockPos bottomPos, int topY) {
        ArrayList<EnumFacing> walls = new ArrayList<EnumFacing>();
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.NORTH), topY)) {
            walls.add(EnumFacing.NORTH);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.WEST), topY)) {
            walls.add(EnumFacing.WEST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.EAST), topY)) {
            walls.add(EnumFacing.EAST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(EnumFacing.SOUTH), topY)) {
            walls.add(EnumFacing.SOUTH);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, int x, int y, int z, EnumFacing backWall, EnumFacing oldSideWall, int top) {
        int oldX = x;
        int oldZ = z;
        EnumFacing sideWall = oldSideWall.func_176734_d();
        boolean stop = false;
        block4: while (!stop) {
            if (backWall == EnumFacing.NORTH || backWall == EnumFacing.SOUTH) {
                x = sideWall == EnumFacing.WEST ? --x : ++x;
            } else {
                z = sideWall == EnumFacing.NORTH ? --z : ++z;
            }
            BlockPos newBottomPos = new BlockPos(x, y, z);
            int newTop = this.getTopBlockY(w, newBottomPos);
            List<EnumFacing> walls = this.getWalls(w, newBottomPos, newTop);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top++ ? !this.isWallColumn(w, new BlockPos(oldX, top, oldZ), newTop) : newTop < top-- && !this.isWallColumn(w, new BlockPos(x, newTop, z), top)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block4;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block4;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public EnumFacing isInFireplace(World w, BlockPos pos) {
        int t;
        if (pos.func_177956_o() < 254 && (t = this.getTopBlockY(w, pos)) > 0) {
            List<EnumFacing> walls = this.getWalls(w, pos, t);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (walls.size()) {
                case 3: {
                    for (EnumFacing ef : HORIZONTALS) {
                        if (walls.contains(ef)) continue;
                        return ef;
                    }
                    break;
                }
                case 2: {
                    if ((!walls.contains(EnumFacing.NORTH) || !walls.contains(EnumFacing.WEST) && !walls.contains(EnumFacing.EAST)) && (!walls.contains(EnumFacing.SOUTH) || !walls.contains(EnumFacing.WEST) && !walls.contains(EnumFacing.EAST))) break;
                    boolean zeroToOne = this.canLoopToCorner(w, x, y, z, walls.get(0), walls.get(1), t);
                    boolean oneToZero = this.canLoopToCorner(w, x, y, z, walls.get(1), walls.get(0), t);
                    if (zeroToOne && oneToZero) {
                        return EnumFacing.UP;
                    }
                    if (zeroToOne) {
                        return walls.get(0).func_176734_d();
                    }
                    if (!oneToZero) break;
                    return walls.get(1).func_176734_d();
                }
                case 1: {
                    switch (walls.get(0)) {
                        case NORTH: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.NORTH, EnumFacing.WEST, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.NORTH, EnumFacing.EAST, t)) {
                                return EnumFacing.SOUTH;
                            }
                        }
                        case WEST: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.WEST, EnumFacing.SOUTH, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.WEST, EnumFacing.NORTH, t)) {
                                return EnumFacing.EAST;
                            }
                        }
                        case EAST: {
                            if (this.canLoopToCorner(w, x, y, z, EnumFacing.EAST, EnumFacing.SOUTH, t) && this.canLoopToCorner(w, x, y, z, EnumFacing.EAST, EnumFacing.NORTH, t)) {
                                return EnumFacing.WEST;
                            }
                        }
                        case SOUTH: {
                            if (!this.canLoopToCorner(w, x, y, z, EnumFacing.SOUTH, EnumFacing.WEST, t) || !this.canLoopToCorner(w, x, y, z, EnumFacing.SOUTH, EnumFacing.EAST, t)) break;
                            return EnumFacing.NORTH;
                        }
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Deprecated
    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

