/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiPeek;
import com.fredtargaryen.floocraft.network.PacketHandler;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceListRequest;
import com.fredtargaryen.floocraft.network.messages.MessagePeekRequest;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import com.fredtargaryen.floocraft.network.messages.MessageTeleportEntity;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiTeleport
extends GuiScreen {
    private static final String screenTitle = "===Choose a destination===";
    private String status;
    private GuiButton peekBtn;
    private GuiButton goBtn;
    private GuiButton cancelBtn;
    private boolean[] enabledList;
    private boolean receivedLists;
    private PlaceScrollWindow scrollWindow;
    private final int initX;
    private final int initY;
    private final int initZ;
    private Object[] placeList;

    public GuiTeleport(int x, int y, int z) {
        this.initX = x;
        this.initY = y;
        this.initZ = z;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.refresh();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146297_k.field_195559_v.func_197967_a(true);
        GuiButton refreshButton = new GuiButton(-2, this.field_146294_l - 100, 0, 98, 20, "Refresh"){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiTeleport.this.refresh();
                GuiTeleport.this.func_73866_w_();
            }
        };
        refreshButton.field_146124_l = false;
        this.peekBtn = new GuiButton(-4, this.field_146294_l / 2 - 151, this.field_146295_m - 40, 98, 20, "Peek..."){

            public void func_194829_a(double mouseX, double mouseY) {
                String dest = (String)GuiTeleport.this.placeList[GuiTeleport.this.scrollWindow.getSelectedElement()];
                try {
                    MessagePeekRequest m = new MessagePeekRequest();
                    m.initX = GuiTeleport.this.initX;
                    m.initY = GuiTeleport.this.initY;
                    m.initZ = GuiTeleport.this.initZ;
                    m.dest = dest;
                    PacketHandler.INSTANCE.sendToServer((Object)m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.func_189646_b(this.peekBtn);
        this.peekBtn.field_146124_l = false;
        this.goBtn = new GuiButton(-3, this.field_146294_l / 2 - 49, this.field_146295_m - 40, 98, 20, "Go!"){

            public void func_194829_a(double mouseX, double mouseY) {
                int initX = GuiTeleport.this.initX;
                int initY = GuiTeleport.this.initY;
                int initZ = GuiTeleport.this.initZ;
                String dest = (String)GuiTeleport.this.placeList[GuiTeleport.this.scrollWindow.getSelectedElement()];
                try {
                    MessageTeleportEntity m = new MessageTeleportEntity();
                    m.initX = initX;
                    m.initY = initY;
                    m.initZ = initZ;
                    m.dest = dest;
                    PacketHandler.INSTANCE.sendToServer((Object)m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GuiTeleport.this.cancelBtn.func_194829_a(0.0, 0.0);
            }
        };
        this.func_189646_b(this.goBtn);
        this.goBtn.field_146124_l = false;
        this.cancelBtn = new GuiButton(-1, this.field_146294_l / 2 + 53, this.field_146295_m - 40, 98, 20, "Cancel"){

            public void func_194829_a(double mouseX, double mouseY) {
                ((ClientProxy)FloocraftBase.proxy).overrideTicker.start();
                GuiTeleport.this.field_146297_k.func_147108_a(null);
            }
        };
        this.func_189646_b(this.cancelBtn);
        if (this.receivedLists) {
            refreshButton.field_146124_l = true;
            this.scrollWindow = new PlaceScrollWindow();
            this.field_195124_j.add(this.scrollWindow);
        }
        this.func_189646_b(refreshButton);
    }

    public void func_146281_b() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        this.field_146297_k.field_195559_v.func_197967_a(false);
        proxy.overrideTicker.start();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.status = !this.receivedLists ? "Loading..." : (this.placeList.length == 0 ? "No places found" : "");
    }

    public boolean charTyped(char par1, int par2) {
        if (par2 == 1) {
            this.cancelBtn.func_194829_a(0.0, 0.0);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_73863_a(int mousex, int mousey, float partialticks) {
        this.func_73732_a(this.field_146289_q, this.status, this.field_146294_l / 2, this.field_146295_m / 4 + 48, 0xC8C8C8);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_146294_l / 2), (float)0.0f, (float)50.0f);
        float f1 = 93.75f;
        GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (this.scrollWindow != null) {
            this.scrollWindow.func_148128_a(mousex, mousey, partialticks);
        }
        this.func_73732_a(this.field_146289_q, screenTitle, this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mousex, mousey, partialticks);
    }

    private void refresh() {
        this.field_195124_j.remove((Object)this.scrollWindow);
        this.scrollWindow = null;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.receivedLists = false;
        PacketHandler.INSTANCE.sendToServer((Object)new MessageFireplaceListRequest());
    }

    public void onFireplaceList(MessageFireplaceList m) {
        try {
            this.placeList = m.places;
            this.enabledList = m.enabledList;
            this.receivedLists = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.func_73866_w_();
    }

    public void onStartPeek(MessageStartPeek msp) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPeek((String)this.placeList[this.scrollWindow.getSelectedElement()], msp.peekerUUID));
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.scrollWindow != null) {
            this.scrollWindow.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return true;
    }

    public boolean func_73868_f() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    class PlaceScrollWindow
    extends GuiListExtended<GuiPlaceEntry> {
        PlaceScrollWindow() {
            super(GuiTeleport.this.field_146297_k, GuiTeleport.this.field_146294_l, GuiTeleport.this.field_146295_m, 32, GuiTeleport.this.field_146295_m - 64, 18);
            this.func_193651_b(true);
            for (int i = 0; i < GuiTeleport.this.placeList.length; ++i) {
                this.func_195085_a(new GuiPlaceEntry(i));
            }
            if (GuiTeleport.this.placeList.length > 0) {
                this.func_195080_b(0);
            }
        }

        public int func_148139_c() {
            return 380;
        }

        public void func_195080_b(int index) {
            boolean enabled;
            super.func_195080_b(index);
            ((GuiTeleport)GuiTeleport.this).goBtn.field_146124_l = enabled = GuiTeleport.this.enabledList[index];
            ((GuiTeleport)GuiTeleport.this).peekBtn.field_146124_l = enabled;
        }

        protected boolean func_148131_a(int id) {
            return id == this.field_148168_r;
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
        }

        public void func_148128_a(int i, int j, float f) {
            super.func_148128_a(i, j, f);
            this.flooverlayBackground(0, this.field_148153_b);
            this.flooverlayBackground(this.field_148154_c, this.field_148158_l);
        }

        private void flooverlayBackground(int p_148136_1_, int p_148136_2_) {
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            GuiTeleport.this.field_146297_k.func_110434_K().func_110577_a(DataReference.TP_BACKGROUND);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b((double)this.field_148152_e, (double)p_148136_2_, 0.0).func_187315_a(0.0, (double)((float)p_148136_2_ / f)).func_181675_d();
            wr.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_2_, 0.0).func_187315_a((double)((float)this.field_148155_a / f), (double)((float)p_148136_2_ / f)).func_181675_d();
            wr.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_1_, 0.0).func_187315_a((double)((float)this.field_148155_a / f), (double)((float)p_148136_1_ / f)).func_181675_d();
            wr.func_181662_b((double)this.field_148152_e, (double)p_148136_1_, 0.0).func_187315_a(0.0, (double)((float)p_148136_1_ / f)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }

        protected void drawContainerBackground(Tessellator tessellator) {
        }

        int getSelectedElement() {
            return this.field_148168_r;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class GuiPlaceEntry
    extends GuiListExtended.IGuiListEntry<GuiPlaceEntry> {
        private int id;

        GuiPlaceEntry(int id) {
            this.id = id;
        }

        public void func_194999_a(int width, int i1, int mouseX, int mouseY, boolean b, float v) {
            GuiTeleport.this.func_73732_a(GuiTeleport.this.field_146289_q, (String)GuiTeleport.this.placeList[this.id], GuiTeleport.this.field_146294_l / 2, this.func_195001_c() + 3, GuiTeleport.this.enabledList[this.id] ? 65280 : 0xFF0000);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            return true;
        }
    }
}

