/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataStorage;

public class FloocraftWorldData
extends WorldSavedData {
    public final ConcurrentHashMap<String, int[]> placeList = new ConcurrentHashMap();

    public FloocraftWorldData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("floocraftft", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
            int[] coords = new int[]{nbt1.func_74762_e("X"), nbt1.func_74762_e("Y"), nbt1.func_74762_e("Z")};
            this.placeList.put(nbt1.func_74779_i("NAME"), coords);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (String nextName : this.placeList.keySet()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("NAME", nextName);
            int[] coords = this.placeList.get(nextName);
            nbt1.func_74768_a("X", coords[0]);
            nbt1.func_74768_a("Y", coords[1]);
            nbt1.func_74768_a("Z", coords[2]);
            nbttaglist.add((INBTBase)nbt1);
        }
        compound.func_74782_a("floocraftft", (INBTBase)nbttaglist);
        return compound;
    }

    public static FloocraftWorldData forWorld(World world) {
        DimensionType dt;
        WorldSavedDataStorage storage = world.func_175693_T();
        FloocraftWorldData data = (FloocraftWorldData)storage.func_212426_a(dt = world.func_201675_m().func_186058_p(), FloocraftWorldData::new, "floocraftft");
        if (data == null) {
            FloocraftBase.warn("[FLOOCRAFT-SERVER] No fireplace data was found for this world. Creating new fireplace data.");
            data = new FloocraftWorldData("floocraftft");
            storage.func_212424_a(dt, "floocraftft", (WorldSavedData)data);
        }
        return data;
    }

    public void addLocation(String name, BlockPos pos) {
        this.placeList.put(name, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        FloocraftBase.info("[FLOOCRAFT-SERVER] Added fireplace at " + pos.toString() + ". Name: " + name);
        this.func_76185_a();
    }

    public void removeLocation(int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        boolean removedPlace = false;
        Iterator i = ((ConcurrentHashMap.KeySetView)this.placeList.keySet()).iterator();
        while (i.hasNext() && !removedPlace) {
            String nextPlaceName = (String)i.next();
            if (!Arrays.equals(this.placeList.get(nextPlaceName), coords)) continue;
            FloocraftBase.info("[FLOOCRAFT-SERVER] Removed fireplace at (" + x + ", " + y + ", " + z + "). Name: " + nextPlaceName);
            this.placeList.remove(nextPlaceName);
            removedPlace = true;
        }
        if (!removedPlace) {
            FloocraftBase.warn("[FLOOCRAFT-SERVER] Failed to remove fireplace at (" + x + ", " + y + ", " + z + ").");
            FloocraftBase.warn("[FLOOCRAFT-SERVER] Data can be manually removed with an NBT editor.");
        }
        this.func_76185_a();
    }

    public MessageFireplaceList assembleNewFireplaceList(World w) {
        MessageFireplaceList m = new MessageFireplaceList();
        m.places = ((ConcurrentHashMap.CollectionView)((Object)this.placeList.keySet())).toArray();
        boolean[] l = new boolean[m.places.length];
        int keyCount = 0;
        for (String nextName : this.placeList.keySet()) {
            boolean ok;
            int[] coords = this.placeList.get(nextName);
            BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
            Block b = w.func_180495_p(dest).func_177230_c();
            if (b instanceof BlockFire) {
                ok = ((GreenFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP).isInFireplace(w, dest) != null;
                w.func_175656_a(dest, Blocks.field_150480_ab.func_176223_P());
            } else {
                ok = b instanceof GreenFlamesBase;
            }
            l[keyCount] = ok;
            ++keyCount;
        }
        m.enabledList = l;
        return m;
    }
}

