/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.tileentity.TileEntityFireplace;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageAddFireplace {
    public String name;
    public BlockPos signPos;
    public BlockPos locationPos;
    private static final Charset defaultCharset = Charset.defaultCharset();

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            WorldServer serverWorld = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            TileEntityFireplace flooSign = (TileEntityFireplace)serverWorld.func_175625_s(this.signPos);
            flooSign.setY(this.locationPos.func_177956_o());
            FloocraftWorldData.forWorld((World)serverWorld).addLocation(this.name, this.locationPos);
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageAddFireplace() {
    }

    public MessageAddFireplace(ByteBuf buf) {
        int nameLength = buf.readInt();
        this.name = buf.readBytes(nameLength).toString(defaultCharset);
        this.locationPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.signPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.name.length());
        buf.writeBytes(this.name.getBytes());
        buf.writeInt(this.locationPos.func_177958_n());
        buf.writeInt(this.locationPos.func_177956_o());
        buf.writeInt(this.locationPos.func_177952_p());
        buf.writeInt(this.signPos.func_177958_n());
        buf.writeInt(this.signPos.func_177956_o());
        buf.writeInt(this.signPos.func_177952_p());
    }
}

