/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.FloocraftBase;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerID {
    public UUID peekerUUID;
    public UUID playerUUID;

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> FloocraftBase.proxy.setUUIDs(this));
        ctx.get().setPacketHandled(true);
    }

    public MessagePlayerID(UUID peekerUUID, UUID playerUUID) {
        this.peekerUUID = peekerUUID;
        this.playerUUID = playerUUID;
    }

    public MessagePlayerID(ByteBuf buf) {
        this.peekerUUID = new UUID(buf.readLong(), buf.readLong());
        this.playerUUID = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.peekerUUID.getMostSignificantBits());
        buf.writeLong(this.peekerUUID.getLeastSignificantBits());
        buf.writeLong(this.playerUUID.getMostSignificantBits());
        buf.writeLong(this.playerUUID.getLeastSignificantBits());
    }
}

