/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.item;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.entity.DroppedFlooPowderEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFlooPowder
extends Item {
    private final byte concentration;

    public byte getConcentration() {
        return this.concentration;
    }

    public ItemFlooPowder(byte conc) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(64));
        this.concentration = conc;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos firePos;
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!worldIn.field_72995_K && worldIn.func_180495_p(firePos = pos.func_177967_a(Direction.UP, 1)).func_177230_c() == Blocks.field_150480_ab) {
            if (((GreenFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP).isInFireplace(worldIn, firePos) != null) {
                worldIn.func_180501_a(firePos, (BlockState)FloocraftBase.GREEN_FLAMES_BUSY.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(this.concentration)), 3);
                worldIn.func_184133_a(null, firePos, FloocraftBase.GREENED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            context.func_195996_i().func_190917_f(-1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (!world.field_72995_K) {
            DroppedFlooPowderEntity flp = new DroppedFlooPowderEntity(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack, this.concentration);
            flp.func_174867_a(40);
            flp.func_213317_d(location.func_213322_ci());
            return flp;
        }
        return null;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.concentration == 9) {
            tooltip.add(new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.concentration", (Object[])new Object[]{Character.valueOf('\u221e')})).func_211708_a(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.creativeonly", (Object[])new Object[0])));
        } else {
            tooltip.add(new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.concentration", (Object[])new Object[]{this.concentration})).func_211708_a(TextFormatting.GREEN));
            if (this.concentration == 1) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.floocraftft.craftable", (Object[])new Object[0])));
            }
        }
    }
}

