/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft;

import com.fredtargaryen.floocraft.block.BlockFloowerPot;
import com.fredtargaryen.floocraft.block.FlooSignBlock;
import com.fredtargaryen.floocraft.block.FlooTorchBlock;
import com.fredtargaryen.floocraft.block.GreenFlamesBusy;
import com.fredtargaryen.floocraft.block.GreenFlamesIdle;
import com.fredtargaryen.floocraft.block.GreenFlamesTemp;
import com.fredtargaryen.floocraft.client.particle.GreenFlameParticle;
import com.fredtargaryen.floocraft.config.Config;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.inventory.container.FloowerPotContainer;
import com.fredtargaryen.floocraft.item.ItemFlooPowder;
import com.fredtargaryen.floocraft.item.ItemFlooSign;
import com.fredtargaryen.floocraft.item.ItemFlooTorch;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import com.fredtargaryen.floocraft.proxy.IProxy;
import com.fredtargaryen.floocraft.proxy.ServerProxy;
import com.fredtargaryen.floocraft.tileentity.FireplaceTileEntity;
import com.fredtargaryen.floocraft.tileentity.FloowerPotTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="floocraftft")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="floocraftft")
public class FloocraftBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @ObjectHolder(value="flootorch")
    public static Block BLOCK_FLOO_TORCH;
    @ObjectHolder(value="greenflamesbusy")
    public static Block GREEN_FLAMES_BUSY;
    @ObjectHolder(value="greenflamesidle")
    public static Block GREEN_FLAMES_IDLE;
    @ObjectHolder(value="greenflamestemp")
    public static Block GREEN_FLAMES_TEMP;
    @ObjectHolder(value="floosign")
    public static Block BLOCK_FLOO_SIGN;
    @ObjectHolder(value="floowerpot")
    public static Block FLOOWER_POT;
    @ObjectHolder(value="floosign")
    public static Item ITEM_FLOO_SIGN;
    @ObjectHolder(value="flootorch")
    public static Item ITEM_FLOO_TORCH;
    @ObjectHolder(value="floowerpot")
    public static Item ITEM_FLOOWER_POT;
    @ObjectHolder(value="floopowder_one")
    public static Item ITEM_FLOO_POWDER_1;
    @ObjectHolder(value="floopowder_two")
    public static Item ITEM_FLOO_POWDER_2;
    @ObjectHolder(value="floopowder_four")
    public static Item ITEM_FLOO_POWDER_4;
    @ObjectHolder(value="floopowder_eight")
    public static Item ITEM_FLOO_POWDER_8;
    @ObjectHolder(value="floopowder_infinite")
    public static Item ITEM_FLOO_POWDER_INFINITE;
    @ObjectHolder(value="pot")
    public static ContainerType<FloowerPotContainer> POT_CONTAINER_TYPE;
    @ObjectHolder(value="greened")
    public static SoundEvent GREENED;
    @ObjectHolder(value="tp")
    public static SoundEvent TP;
    @ObjectHolder(value="flick")
    public static SoundEvent FLICK;
    @ObjectHolder(value="peeker")
    public static EntityType<PeekerEntity> PEEKER_TYPE;
    @ObjectHolder(value="greenflame")
    public static BasicParticleType GREEN_FLAME;
    @ObjectHolder(value="fireplace")
    public static TileEntityType<FireplaceTileEntity> FIREPLACE_TYPE;
    @ObjectHolder(value="pot")
    public static TileEntityType<FloowerPotTileEntity> POT_TYPE;
    public static IProxy proxy;

    public FloocraftBase() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG_SPEC);
        IEventBus loadingBus = FMLJavaModLoadingContext.get().getModEventBus();
        loadingBus.addListener(this::postRegistration);
        loadingBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(FMLPaths.CONFIGDIR.get().resolve("floocraftft.toml"));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new FlooTorchBlock().setRegistryName("flootorch"), (Block)new GreenFlamesBusy().setRegistryName("greenflamesbusy"), (Block)new GreenFlamesIdle().setRegistryName("greenflamesidle"), (Block)new GreenFlamesTemp().setRegistryName("greenflamestemp"), (Block)new FlooSignBlock().setRegistryName("floosign"), (Block)new BlockFloowerPot().setRegistryName("floowerpot")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemFlooTorch().setRegistryName("flootorch"), (Item)new BlockItem(FLOOWER_POT, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("floowerpot"), (Item)new ItemFlooPowder(1).setRegistryName("floopowder_one"), (Item)new ItemFlooPowder(2).setRegistryName("floopowder_two"), (Item)new ItemFlooPowder(4).setRegistryName("floopowder_four"), (Item)new ItemFlooPowder(8).setRegistryName("floopowder_eight"), (Item)new ItemFlooPowder(9).setRegistryName("floopowder_infinite"), (Item)new ItemFlooSign(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16)).setRegistryName("floosign")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new FloowerPotContainer(windowId, inv, inv.field_70458_d.field_70170_p, data.func_179259_c())).setRegistryName("pot"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)EntityType.Builder.func_220322_a((type, world) -> new PeekerEntity(world), (EntityClassification)EntityClassification.MISC).setTrackingRange(32).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false).func_220320_c().func_220321_a(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new PeekerEntity((World)world)).func_206830_a("floocraftft").setRegistryName("peeker")});
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        event.getRegistry().register(new BasicParticleType(false).setRegistryName("greenflame"));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)GREEN_FLAME, GreenFlameParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "greened")).setRegistryName("greened"), (SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "tp")).setRegistryName("tp"), (SoundEvent)new SoundEvent(new ResourceLocation("floocraftft", "flick")).setRegistryName("flick")});
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)TileEntityType.Builder.func_223042_a(FireplaceTileEntity::new, (Block[])new Block[]{BLOCK_FLOO_SIGN}).func_206865_a(null).setRegistryName("fireplace"), (TileEntityType)TileEntityType.Builder.func_223042_a(FloowerPotTileEntity::new, (Block[])new Block[]{FLOOWER_POT}).func_206865_a(null).setRegistryName("pot")});
    }

    public void postRegistration(FMLCommonSetupEvent event) {
        MessageHandler.init();
        proxy.registerTickHandlers();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        proxy.registerGUIs();
        proxy.registerRenderers();
        proxy.setupRenderTypes();
    }

    @SubscribeEvent
    public static void handleMissingMappings(RegistryEvent.MissingMappings evt) {
        block57: {
            String fullName;
            block59: {
                block58: {
                    block56: {
                        fullName = evt.getName().toString();
                        if (!fullName.equals("minecraft:blocks")) break block56;
                        for (Object mapping : evt.getAllMappings()) {
                            RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                            if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                            switch (trueMapping.key.func_110623_a()) {
                                case "flootorch": {
                                    trueMapping.remap((IForgeRegistryEntry)BLOCK_FLOO_TORCH);
                                    break;
                                }
                                case "greenflamesbusy": {
                                    trueMapping.remap((IForgeRegistryEntry)GREEN_FLAMES_BUSY);
                                    break;
                                }
                                case "greenflamesidle": {
                                    trueMapping.remap((IForgeRegistryEntry)GREEN_FLAMES_IDLE);
                                    break;
                                }
                                case "greenflamestemp": {
                                    trueMapping.remap((IForgeRegistryEntry)GREEN_FLAMES_TEMP);
                                    break;
                                }
                                case "blockfloosign": {
                                    trueMapping.remap((IForgeRegistryEntry)BLOCK_FLOO_SIGN);
                                    break;
                                }
                                case "floowerpot": {
                                    trueMapping.remap((IForgeRegistryEntry)FLOOWER_POT);
                                    break;
                                }
                            }
                        }
                        break block57;
                    }
                    if (!fullName.equals("minecraft:items")) break block58;
                    for (Object mapping : evt.getAllMappings()) {
                        RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                        if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                        switch (trueMapping.key.func_110623_a()) {
                            case "flootorch": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_TORCH);
                                break;
                            }
                            case "floowerpot": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOOWER_POT);
                                break;
                            }
                            case "floopowder_one": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_POWDER_1);
                                break;
                            }
                            case "floopowder_two": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_POWDER_2);
                                break;
                            }
                            case "floopowder_four": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_POWDER_4);
                                break;
                            }
                            case "floopowder_eight": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_POWDER_8);
                                break;
                            }
                            case "floopowder_infinite": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_POWDER_INFINITE);
                                break;
                            }
                            case "itemfloosign": {
                                trueMapping.remap((IForgeRegistryEntry)ITEM_FLOO_SIGN);
                                break;
                            }
                        }
                    }
                    break block57;
                }
                if (!fullName.equals("minecraft:entities")) break block59;
                for (Object mapping : evt.getAllMappings()) {
                    RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                    if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                    switch (trueMapping.key.func_110623_a()) {
                        case "peeker": {
                            trueMapping.remap(ForgeRegistries.ENTITIES.getValue(PEEKER_TYPE.getRegistryName()));
                            break;
                        }
                    }
                }
                break block57;
            }
            if (!fullName.equals("minecraft:soundevents")) break block57;
            for (Object mapping : evt.getAllMappings()) {
                RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                if (!trueMapping.key.func_110624_b().equals("ftfloocraft")) continue;
                switch (trueMapping.key.func_110623_a()) {
                    case "tp": {
                        trueMapping.remap((IForgeRegistryEntry)TP);
                        break;
                    }
                    case "flick": {
                        trueMapping.remap((IForgeRegistryEntry)FLICK);
                        break;
                    }
                    case "greened": {
                        trueMapping.remap((IForgeRegistryEntry)GREENED);
                        break;
                    }
                }
            }
        }
    }

    public static void info(String message) {
        LOGGER.info(message);
    }

    public static void warn(String message) {
        LOGGER.warn(message);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    }
}

