/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.TeleportScreen;
import com.fredtargaryen.floocraft.config.GeneralConfig;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GreenFlamesBase
extends Block {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final VoxelShape TALLBOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    GreenFlamesBase(int lightLevel) {
        super(Block.Properties.func_200945_a((Material)Material.field_151581_o).func_200951_a(lightLevel).func_226896_b_());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208171_X});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return TALLBOX;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            if (entityIn == Minecraft.func_71410_x().field_71439_g) {
                this.doClientGuiTings(pos);
            }
        } else if (!(entityIn instanceof PlayerEntity)) {
            boolean teleport = false;
            boolean landOutside = false;
            if (((Boolean)GeneralConfig.ITEMS_TELEPORT.get()).booleanValue() && entityIn instanceof ItemEntity) {
                teleport = true;
                landOutside = true;
            } else if (((Boolean)GeneralConfig.VILLAGERS_TELEPORT.get()).booleanValue() && entityIn instanceof VillagerEntity || ((Boolean)GeneralConfig.MISC_MOBS_TELEPORT.get()).booleanValue() && entityIn instanceof LivingEntity) {
                boolean bl = teleport = (double)worldIn.field_73012_v.nextFloat() < 0.2;
            }
            if (teleport) {
                FloocraftWorldData fwd = FloocraftWorldData.forWorld(worldIn);
                MessageFireplaceList mfl = fwd.assembleNewFireplaceList(worldIn);
                ArrayList<String> possibleLocations = new ArrayList<String>();
                for (int i = 0; i < mfl.places.length; ++i) {
                    if (!mfl.enabledList[i]) continue;
                    possibleLocations.add((String)mfl.places[i]);
                }
                if (!possibleLocations.isEmpty()) {
                    int destNo = worldIn.field_73012_v.nextInt(possibleLocations.size());
                    String destName = (String)possibleLocations.get(destNo);
                    int[] coords = fwd.placeList.get(destName);
                    BlockPos dest = new BlockPos(coords[0], coords[1], coords[2]);
                    if (worldIn.func_180495_p(dest).func_177230_c() == Blocks.field_150480_ab) {
                        worldIn.func_175656_a(dest, FloocraftBase.GREEN_FLAMES_TEMP.func_176223_P());
                    }
                    if (landOutside) {
                        dest = dest.func_177972_a(this.isInFireplace(worldIn, dest));
                        entityIn.func_70012_b((double)dest.func_177958_n(), (double)coords[1], (double)dest.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
                    } else {
                        entityIn.func_70012_b((double)coords[0], (double)coords[1], (double)coords[2], entityIn.field_70177_z, entityIn.field_70125_A);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientGuiTings(BlockPos pos) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new TeleportScreen(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(IWorldReader par1World) {
        return 30;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean b) {
        if (this.isInFireplace(worldIn, pos) != null) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this.isInFireplace((World)world, pos) == null || ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperties.field_208171_X)).equals(0)) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        } else {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + rand.nextInt(10));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        this.doSmokeParticles(stateIn, worldIn, pos, rand);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void doSmokeParticles(BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(8) == 0) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    private int getTopBlockY(World w, BlockPos pos) {
        BlockPos newPos = pos.func_177967_a(Direction.UP, 1);
        int y = newPos.func_177956_o();
        BlockState bs = w.func_180495_p(newPos);
        while (bs.func_177230_c().isAir(bs, (IBlockReader)w, newPos) && y < 256) {
            newPos = newPos.func_177967_a(Direction.UP, 1);
            y = newPos.func_177956_o();
            bs = w.func_180495_p(newPos);
        }
        if (bs.func_185904_a().func_76220_a()) {
            return y;
        }
        return 0;
    }

    private boolean isWallColumn(World w, BlockPos bottomPos, int topY) {
        boolean valid = true;
        BlockPos newBottomPos = bottomPos;
        while (valid && newBottomPos.func_177956_o() < topY) {
            BlockState bs = w.func_180495_p(newBottomPos);
            if (bs.func_185904_a().func_76220_a()) {
                newBottomPos = newBottomPos.func_177967_a(Direction.UP, 1);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<Direction> getWalls(World w, BlockPos bottomPos, int topY) {
        ArrayList<Direction> walls = new ArrayList<Direction>();
        if (this.isWallColumn(w, bottomPos.func_177972_a(Direction.NORTH), topY)) {
            walls.add(Direction.NORTH);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(Direction.WEST), topY)) {
            walls.add(Direction.WEST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(Direction.EAST), topY)) {
            walls.add(Direction.EAST);
        }
        if (this.isWallColumn(w, bottomPos.func_177972_a(Direction.SOUTH), topY)) {
            walls.add(Direction.SOUTH);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, int x, int y, int z, Direction backWall, Direction oldSideWall, int top) {
        int oldX = x;
        int oldZ = z;
        Direction sideWall = oldSideWall.func_176734_d();
        boolean stop = false;
        block4: while (!stop) {
            if (backWall == Direction.NORTH || backWall == Direction.SOUTH) {
                x = sideWall == Direction.WEST ? --x : ++x;
            } else {
                z = sideWall == Direction.NORTH ? --z : ++z;
            }
            BlockPos newBottomPos = new BlockPos(x, y, z);
            int newTop = this.getTopBlockY(w, newBottomPos);
            List<Direction> walls = this.getWalls(w, newBottomPos, newTop);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top++ ? !this.isWallColumn(w, new BlockPos(oldX, top, oldZ), newTop) : newTop < top-- && !this.isWallColumn(w, new BlockPos(x, newTop, z), top)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block4;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block4;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public Direction isInFireplace(World w, BlockPos pos) {
        int t;
        if (pos.func_177956_o() < 254 && (t = this.getTopBlockY(w, pos)) > 0) {
            List<Direction> walls = this.getWalls(w, pos, t);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (walls.size()) {
                case 3: {
                    for (Direction ef : HORIZONTALS) {
                        if (walls.contains(ef)) continue;
                        return ef;
                    }
                    break;
                }
                case 2: {
                    if ((!walls.contains(Direction.NORTH) || !walls.contains(Direction.WEST) && !walls.contains(Direction.EAST)) && (!walls.contains(Direction.SOUTH) || !walls.contains(Direction.WEST) && !walls.contains(Direction.EAST))) break;
                    boolean zeroToOne = this.canLoopToCorner(w, x, y, z, walls.get(0), walls.get(1), t);
                    boolean oneToZero = this.canLoopToCorner(w, x, y, z, walls.get(1), walls.get(0), t);
                    if (zeroToOne && oneToZero) {
                        return Direction.UP;
                    }
                    if (zeroToOne) {
                        return walls.get(0).func_176734_d();
                    }
                    if (!oneToZero) break;
                    return walls.get(1).func_176734_d();
                }
                case 1: {
                    switch (walls.get(0)) {
                        case NORTH: {
                            if (this.canLoopToCorner(w, x, y, z, Direction.NORTH, Direction.WEST, t) && this.canLoopToCorner(w, x, y, z, Direction.NORTH, Direction.EAST, t)) {
                                return Direction.SOUTH;
                            }
                        }
                        case WEST: {
                            if (this.canLoopToCorner(w, x, y, z, Direction.WEST, Direction.SOUTH, t) && this.canLoopToCorner(w, x, y, z, Direction.WEST, Direction.NORTH, t)) {
                                return Direction.EAST;
                            }
                        }
                        case EAST: {
                            if (this.canLoopToCorner(w, x, y, z, Direction.EAST, Direction.SOUTH, t) && this.canLoopToCorner(w, x, y, z, Direction.EAST, Direction.NORTH, t)) {
                                return Direction.WEST;
                            }
                        }
                        case SOUTH: {
                            if (!this.canLoopToCorner(w, x, y, z, Direction.SOUTH, Direction.WEST, t) || !this.canLoopToCorner(w, x, y, z, Direction.SOUTH, Direction.EAST, t)) break;
                            return Direction.NORTH;
                        }
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }
}

